/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.events;

import com.metabrain.gdb.BigArray;
import java.util.ArrayList;
import java.util.List;
import net.vavilon.servers.model.Post;
import org.exchange.events.model.Event;

public abstract class EventsUtils
extends Post {
    protected static String APP = "events";
    private final List<Event> newEvents = new ArrayList<Event>();
    public static final BigArray<Event> events = new BigArray<Event>(APP, "events", Event.class, Long.MAX_VALUE);

    @Override
    public void commit() {
        for (Event event : this.newEvents) {
            events.add(event);
        }
        this.newEvents.clear();
    }

    public void trackEvent(String name, String value, String userId, String session) {
        Event event = new Event();
        event.time = this.time();
        event.name = name;
        event.value = value;
        event.user_id = userId;
        event.session = session;
        this.newEvents.add(event);
    }

    public Event getEvent(String name, String value, String session) {
        List<Event> events = this.getEvents(name, value, session, null, 1L);
        return events.isEmpty() ? null : events.get(0);
    }

    public List<Event> getEvents(String name, String value, String session, Long fromTime, Long size) {
        Event event;
        long i = events.size() - 1L;
        ArrayList<Event> result = new ArrayList<Event>();
        while (i >= 0L && (long)result.size() < size && (fromTime == null || fromTime > 0L) && (event = events.get(i)) != null) {
            if (name != null && !name.equals(event.name)) {
                --i;
                continue;
            }
            if (value != null && !value.equals(event.value)) {
                --i;
                continue;
            }
            if (session != null && !session.equals(event.session)) {
                --i;
                continue;
            }
            if (fromTime != null && event.time < fromTime) break;
            result.add(event);
            --i;
        }
        return result;
    }
}

