/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.events;

import com.metabrain.gdb.BigMap;
import com.metabrain.gdb.MultiTop;
import java.util.List;
import net.vavilon.servers.model.Get;
import net.vavilon.utils.Request;
import org.exchange.events.EventsUtils;
import org.exchange.events.model.Transition;

public class Recommendations
extends Get {
    public static final String MODULE = "recs";
    public static final BigMap<Transition> countsByWindow = new BigMap<Transition>(EventsUtils.APP + "/" + "recs", "countsByWindow", Transition.class);
    public static final MultiTop<Transition> topByWindow = new MultiTop<Transition>(EventsUtils.APP + "/" + "recs", "recs", Transition.class, (a, b) -> Long.compare(b.count, a.count), 10);

    public static void addTransition(String from, String to) {
        if (from == null) {
            return;
        }
        if (to == null) {
            return;
        }
        if (from.equals(to)) {
            return;
        }
        String key = from + ":" + to;
        Transition transition = countsByWindow.get(key);
        if (transition == null) {
            transition = new Transition(to, 0L);
        }
        ++transition.count;
        countsByWindow.put(key, transition);
        topByWindow.put(from, transition);
    }

    @Override
    public Response get() {
        String from = this.getRequired("from");
        Response response = new Response();
        response.recommended = topByWindow.getTop(from);
        return response;
    }

    public static Response request(String from) {
        return (Response)new Recommendations().run(null, Request.map("from", from));
    }

    public class Response
    extends Get.Response {
        public List<Transition> recommended;
    }
}

