/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.events;

import com.metabrain.gdb.BigFile;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import net.vavilon.Node;
import net.vavilon.NodeInit;
import org.exchange.events.EventsUtils;
import org.exchange.events.Recommendations;
import org.exchange.telegram.Telegram;
import org.exchange.telegram.TelegramUtils;
import org.exchange.telegram.model.TelegramUser;
import org.exchange.telegram.utils.Format;

public class Track
extends EventsUtils {
    private static final Map<String, String> currentWindowBySession = new LinkedHashMap<String, String>(1000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 1000;
        }
    };

    @Override
    public void run() {
        String name = this.getRequired("name");
        String value = this.getString("value");
        String user_id = this.getString("user_id");
        String session = this.getString("session");
        if (name.equals("start")) {
            value = value + "," + (String)this.headers.get("browser") + "," + this.getLanguage() + "," + (String)this.headers.get("os") + (String)this.headers.get("os_version");
            TelegramUser user = TelegramUtils.getUserByAddress(user_id);
            if (user != null) {
                user.timezoneOffsetMinutes = this.getLong("timezone_offset_minutes", user.timezoneOffsetMinutes);
                user.language_code = this.getString("language_code", user.language_code);
                Calendar serverTime = user.getUserTime(this.time());
                Calendar lastVisit = user.getUserTime(user.last_activity_date);
                if (serverTime.get(1) != lastVisit.get(1) || serverTime.get(6) != lastVisit.get(6)) {
                    ++user.total_visit_days;
                    if (serverTime.get(6) != lastVisit.get(6) - 1) {
                        ++user.visit_streak;
                    }
                    if (user.visit_streak > user.max_visit_streak) {
                        user.max_visit_streak = user.visit_streak;
                    }
                }
                user.last_activity_date = this.time();
                if (user.registration_date == 0L) {
                    user.registration_date = user.last_activity_date;
                }
                TelegramUtils.usersByUserId.put("" + user.id, user);
            }
        }
        if (name.equals("openProfile")) {
            String fromWindow = currentWindowBySession.get(session);
            String toWindow = value;
            if (fromWindow != null && toWindow != null) {
                Recommendations.addTransition(fromWindow, toWindow);
            }
            currentWindowBySession.put(session, toWindow);
        }
        this.trackEvent(name, value, user_id, session);
        if (Node.masterNode != null && !BigFile.isDebugMode) {
            Telegram.sendToAdmin(Format.formatAddressShort(user_id), name, value, "" + this.time(), name.equals("start") && !user_id.equals(NodeInit.USER_ADDRESS) && !user_id.equals(NodeInit.TG_USER_ADDRESS));
        }
    }
}

