/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange;

import com.metabrain.gdb.BigChain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.vavilon.token.Send;
import net.vavilon.utils.Utils;
import org.exchange.exchange.LiquidityBot;
import org.exchange.exchange.model.Order;

public abstract class ExchangeUtils
extends Send {
    public static final String APP = "exchange";
    private final Map<Long, Order> newOrders = new HashMap<Long, Order>();
    private static final BigChain<Order> historyOrders = new BigChain<Order>("exchange", "historyOrders", Order.class);
    public static final Map<String, Double> balances = new HashMap<String, Double>();
    public static final Map<String, List<Order>> waitOrders = new ConcurrentHashMap<String, List<Order>>();
    public static final Map<Long, Order> activeOrders = new ConcurrentHashMap<Long, Order>();

    void setOrder(Order order) {
        this.newOrders.put(order.order_id, order);
    }

    protected Order getOrderCached(long orderId) {
        Order order = this.newOrders.get(orderId);
        if (order == null && (order = activeOrders.get(orderId)) != null) {
            order = new Order(order);
        }
        return order;
    }

    @Override
    public void commit() {
        this.commitOrders();
        super.commit();
    }

    private void commitOrders() {
        for (Order order : this.newOrders.values()) {
            if (order.status == 1L || order.status == -1L) {
                if (LiquidityBot.botAddressToDomain.get(order.address) == null) {
                    double amountToGet = 0.0;
                    double totalToGet = 0.0;
                    if (order.is_sell == 1L) {
                        amountToGet = Utils.round(order.amount - order.amount_filled);
                        totalToGet = Utils.round(order.total_filled);
                    } else if (order.is_sell == 0L) {
                        totalToGet = Utils.round(order.total - order.total_filled);
                        amountToGet = Utils.round(order.amount_filled);
                    }
                    String bot_password = LiquidityBot.liquidityBots.get((Object)order.domain).bot_password;
                    String bot_address = LiquidityBot.liquidityBots.get((Object)order.domain).bot_address;
                    if (totalToGet > 0.0) {
                        Send.request("usdt", bot_address, order.address, totalToGet, Send.tokenPass("usdt", bot_address, bot_password), null);
                    }
                    if (amountToGet > 0.0) {
                        Send.request(order.domain, bot_address, order.address, amountToGet, Send.tokenPass(order.domain, bot_address, bot_password), null);
                    }
                    historyOrders.put(order.domain + ":" + order.address, order);
                }
                activeOrders.remove(order.order_id);
                continue;
            }
            activeOrders.put(order.order_id, order);
        }
        this.newOrders.clear();
    }

    public static List<Order> ordersHistory(String domain, String address, long offset, long size) {
        return historyOrders.getPageReverse(domain + ":" + address, offset, size);
    }
}

