/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange;

import java.util.List;
import net.vavilon.servers.model.Get;
import org.exchange.exchange.ExchangeUtils;
import org.exchange.exchange.LiquidityBot;
import org.exchange.exchange.Place;
import org.exchange.exchange.model.Order;

public class Orders
extends Get {
    @Override
    public Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddress("address");
        LiquidityBot bot = LiquidityBot.liquidityBots.computeIfAbsent(domain, domain2 -> new LiquidityBot((String)domain2));
        bot.refresh();
        Response response = new Response();
        response.bot_address = bot.bot_address;
        response.active = Place.ordersActive(domain, address);
        response.history = ExchangeUtils.ordersHistory(domain, address, 0L, 10L);
        return response;
    }

    class Response
    extends Get.Response {
        public String bot_address;
        public List<Order> active;
        public List<Order> history;

        Response() {
        }
    }
}

