/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange;

import com.metabrain.gdb.Top;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.vavilon.charts.Chart;
import net.vavilon.servers.WssServer;
import net.vavilon.token.model.Token;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;
import org.exchange.exchange.ExchangeUtils;
import org.exchange.exchange.model.Order;
import org.exchange.exchange.model.PriceLevel;

public class Place
extends ExchangeUtils {
    public static final String LIMIT = "limit";
    public static final String POST_LIMIT = "post_limit";
    public static final Top<Token> topVolume24 = new Top<Token>("exchange", "topVolume24", Token.class, Comparator.comparingDouble(t -> t.volume24), 10);

    @Override
    public void run() {
        String orderType = this.getString("order_type", LIMIT);
        String domain = this.getRequired("domain");
        Long is_sell = this.getLongRequired("is_sell");
        double price = this.getDoubleRequired("price");
        double amount = this.getDoubleRequired("amount");
        double total = this.getDoubleRequired("total");
        String address = this.getAddress("address");
        if (price != Utils.round(price)) {
            Utils.error("max price decimals is 4");
        }
        if (price <= 0.0) {
            Utils.error("price less than 0");
        }
        if (amount != Utils.round(amount)) {
            Utils.error("max amount decimals is 4");
        }
        if (amount <= 0.0) {
            Utils.error("amount less than 0");
        }
        if (orderType.equals(POST_LIMIT)) {
            waitOrders.computeIfAbsent(address, k -> new ArrayList()).add(new Order(LIMIT, address, domain, is_sell, price, amount, total, this.time()));
        } else if (orderType.equals(LIMIT)) {
            if (is_sell == 1L) {
                this.orderFillSell(address, domain, price, amount);
            } else {
                this.orderFillBuy(address, domain, price, total);
            }
            if (Utils.isNotEmpty(this.scriptPath)) {
                WssServer.broadcast("orderbook:" + domain, Request.map("x", "1"));
            }
        }
    }

    public static void place(String domain, boolean isSell, double price, double amount, double total, String address) {
        new Place().run("", Request.map("domain", domain, "is_sell", isSell ? 1 : 0, "price", price, "amount", amount, "total", total, "address", address));
    }

    public static void buy(String domain, double price, double total, String address) {
        new Place().run("", Request.map("order_type", POST_LIMIT, "domain", domain, "is_sell", "0", "price", "" + price, "amount", "1.0E-4", "total", "" + total, "address", address));
    }

    public static void sell(String domain, double price, double amount, String address) {
        new Place().run("", Request.map("order_type", POST_LIMIT, "domain", domain, "is_sell", "1", "price", "" + price, "amount", "" + amount, "total", "1.0E-4", "address", address));
    }

    public List<Order> getOrders(String domain, int is_sell, double price) {
        ArrayList<Order> result = new ArrayList<Order>();
        for (Order order : activeOrders.values()) {
            if (!order.domain.equals(domain) || order.is_sell != (long)is_sell || order.status != 0L || !(is_sell == 1 ? order.price <= price : order.price >= price)) continue;
            result.add(order);
        }
        result.sort((o1, o2) -> is_sell == 1 ? Double.compare(o1.price, o2.price) : Double.compare(o2.price, o1.price));
        return result;
    }

    protected static double getExchangeBalance(String domain, String address) {
        Double balance = (Double)balances.get(Place.userBalanceName(address, domain));
        if (balance == null) {
            balance = 0.0;
        }
        return balance;
    }

    public static void balanceSend(String domain, String from_user, String to_user, Double amount) {
        if (amount < 0.0) {
            Utils.error("amount less than 0");
        }
        if (amount - Utils.round(amount) != 0.0) {
            Utils.error("max amount decimals is 4");
        }
        if (Place.getExchangeBalance(domain, from_user) < amount) {
            Utils.error("from user balance is not enough");
        }
        Place.incBalance(domain, from_user, -amount.doubleValue());
        Place.incBalance(domain, to_user, amount);
    }

    public void orderFillSell(String address, String domain, double price, double amount) {
        String orderbookAddress = domain;
        Place.balanceSend(domain, address, domain, amount);
        double total = Utils.round(price * amount);
        Order newOrder = new Order(address, domain, 1, price, amount, total);
        double tradeVolume = 0.0;
        double lastTradePrice = 0.0;
        for (Order order : this.getOrders(domain, 0, price)) {
            double amountNotFilled = Utils.round(newOrder.amount - newOrder.amount_filled);
            if (amountNotFilled == 0.0) break;
            double orderTotalNotFilled = Utils.round(order.total - order.total_filled);
            double orderAmountNotFilled = orderTotalNotFilled / order.price;
            double amountToFill = Math.min(orderAmountNotFilled, amountNotFilled);
            double totalToFill = amountToFill * order.price;
            order.amount_filled = Utils.round(order.amount_filled + amountToFill);
            order.total_filled = Utils.round(order.total_filled + totalToFill);
            order.status = orderAmountNotFilled == amountToFill ? 1L : 0L;
            this.setOrder(order);
            if (orderAmountNotFilled == amountToFill) {
                double amountFilled = this.getOrderCached((long)order.order_id).amount_filled;
                Place.balanceSend(domain, orderbookAddress, order.address, amountFilled);
            }
            newOrder.amount_filled = Utils.round(newOrder.amount_filled + amountToFill);
            newOrder.total_filled = Utils.round(newOrder.total_filled + totalToFill);
            lastTradePrice = order.price;
            tradeVolume += totalToFill;
        }
        if (newOrder.amount == newOrder.amount_filled) {
            Place.balanceSend("usdt", orderbookAddress, address, newOrder.total_filled);
            newOrder.status = 1L;
        }
        this.setOrder(newOrder);
        this.trackFill(domain, lastTradePrice, tradeVolume);
    }

    public void orderFillBuy(String address, String domain, double price, double total) {
        String orderbookAddress = domain;
        Place.balanceSend("usdt", address, orderbookAddress, total);
        double amount = Utils.round(total / price);
        Order newOrder = new Order(address, domain, 0, price, amount, total);
        double tradeVolume = 0.0;
        double lastTradePrice = 0.0;
        for (Order order : this.getOrders(domain, 1, price)) {
            double totalNotFilled = Utils.round(newOrder.total - newOrder.total_filled);
            if (totalNotFilled == 0.0) break;
            double orderAmountNotFilled = Utils.round(order.amount - order.amount_filled);
            double orderTotalNotFilled = orderAmountNotFilled * order.price;
            double totalToFill = Math.min(orderTotalNotFilled, totalNotFilled);
            double amountToFill = totalToFill / order.price;
            order.amount_filled = Utils.round(order.amount_filled + amountToFill);
            order.total_filled = Utils.round(order.total_filled + totalToFill);
            order.status = orderTotalNotFilled == totalToFill ? 1L : 0L;
            this.setOrder(order);
            if (orderTotalNotFilled == totalToFill) {
                double totalFilled = this.getOrderCached((long)order.order_id).total_filled;
                Place.balanceSend("usdt", orderbookAddress, order.address, totalFilled);
            }
            newOrder.amount_filled = Utils.round(newOrder.amount_filled + amountToFill);
            newOrder.total_filled = Utils.round(newOrder.total_filled + totalToFill);
            lastTradePrice = order.price;
            tradeVolume += totalToFill;
        }
        if (newOrder.total == newOrder.total_filled) {
            Place.balanceSend(domain, orderbookAddress, address, newOrder.amount_filled);
            newOrder.status = 1L;
        }
        this.setOrder(newOrder);
        this.trackFill(domain, lastTradePrice, tradeVolume);
    }

    public void trackFill(String domain, double price, double volume) {
        if (price != 0.0) {
            this.trackAccumulate("exchange", domain + "_volume", volume);
            Token token = Place.getToken(domain);
            token.price = Chart.getChartLastValue("exchange", domain + "_price");
            token.price24 = Chart.getChange24hPercent("exchange", domain + "_price");
            token.volume24 = Chart.getChange24hTotal("exchange", domain + "_volume");
            this.setToken(token);
            tokensByDomain.put(domain, token);
            topVolume24.add(token);
            double lastPrice = Chart.getChartLastValue("exchange", domain + "_price");
            if (price != lastPrice) {
                this.trackLinear("exchange", domain + "_price", price);
                WssServer.broadcast("price:" + domain, Request.map("price", "" + price));
                WssServer.broadcast("price", Request.map("domain", domain, "price", "" + price, "price24", "" + token.price24));
            }
        }
    }

    public static double getMarketPrice(String domain) {
        return Chart.getChartLastValue("exchange", domain + "_price");
    }

    public static double getVolume(String domain) {
        return Chart.getChartLastValue("exchange", domain + "_volume");
    }

    public static List<Order> ordersActive(String domain, String address) {
        ArrayList<Order> result = new ArrayList<Order>();
        for (Order order : activeOrders.values()) {
            if (!order.domain.equals(domain) || !order.address.equals(address)) continue;
            result.add(new Order(order));
        }
        result.sort((o1, o2) -> Long.compare(o2.timestamp, o1.timestamp));
        return result;
    }

    public static List<PriceLevel> getPriceLevels(String domain, boolean isSell, int count) {
        HashMap<Double, PriceLevel> levels = new HashMap<Double, PriceLevel>();
        for (Order order : activeOrders.values()) {
            if (!order.domain.equals(domain) || order.is_sell != (long)(isSell ? 1 : 0) || order.status != 0L) continue;
            if (levels.containsKey(order.price)) {
                PriceLevel level = (PriceLevel)levels.get(order.price);
                level.amount += order.amount - order.amount_filled;
                continue;
            }
            levels.put(order.price, new PriceLevel(order.price, order.amount - order.amount_filled));
        }
        ArrayList<PriceLevel> levelsList = new ArrayList<PriceLevel>(levels.values());
        levelsList.sort((o1, o2) -> isSell ? Double.compare(o1.price, o2.price) : Double.compare(o2.price, o1.price));
        return levelsList.size() > count ? levelsList.subList(0, count) : levelsList;
    }

    public static String userBalanceName(String domain, String username) {
        return username + ":" + domain;
    }

    public static void incBalance(String domain, String address, Double amount) {
        String userBalanceName = Place.userBalanceName(address, domain);
        Double balance = (Double)balances.get(userBalanceName);
        if (balance == null) {
            balance = 0.0;
        }
        if (amount < 0.0 && balance < amount) {
            Utils.error("not enough balance");
        }
        balance = Utils.round(balance + amount);
        balances.put(userBalanceName, balance);
    }
}

