/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange.bot;

import net.vavilon.token.Send;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Settings;
import net.vavilon.utils.Utils;
import org.exchange.exchange.LiquidityBot;
import org.exchange.exchange.Place;
import org.exchange.miner.AccountInfo;
import org.exchange.miner.MinerSend;
import org.exchange.miner.ToggleDomain;
import org.exchange.miner.Withdrawal;

public class MinerBot
implements InfiniteTimer.Callback {
    public static final String SEED = Settings.get("exchange", MinerBot.class.getSimpleName() + "_seed");
    public String bot_password;
    public String bot_address;
    private String domain;

    public MinerBot(String domain) {
        this.domain = domain;
        this.bot_password = Utils.hash(SEED + " " + domain);
        this.bot_address = Send.hashAddress(this.bot_password);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        }
    }

    @Override
    public void onTimer() throws Exception {
        AccountInfo.Response account = AccountInfo.request(this.bot_address, this.domain);
        if (account.token_account == null || !Utils.contains(account.miner_account.domains, this.domain)) {
            ToggleDomain.request(this.domain, this.bot_address);
        } else if (account.token_account.balance > 0.0) {
            Withdrawal.request(this.domain, this.bot_address);
            LiquidityBot bot = LiquidityBot.liquidityBots.get(this.domain);
            Place.sell(this.domain, 1.0E-4, account.token_account.balance, this.bot_address);
            Send.request(this.domain, this.bot_address, bot.bot_address, account.token_account.balance, Send.tokenPass(this.domain, this.bot_address, this.bot_password), null);
        }
        double gas_balance = Send.getBalanceOrZero("usdt", this.bot_address);
        if (gas_balance > 0.0) {
            MinerSend.deposit(this.bot_address, gas_balance, Send.tokenPass("usdt", this.bot_address, this.bot_password));
        }
    }
}

