/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange.bot;

import net.vavilon.contract.Mint;
import net.vavilon.token.Send;
import net.vavilon.token.model.Token;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Settings;
import net.vavilon.utils.Utils;
import org.exchange.exchange.CancelAll;
import org.exchange.exchange.LiquidityBot;
import org.exchange.exchange.Place;
import org.exchange.miner.Miner;

public class SelfCostBot
implements InfiniteTimer.Callback {
    public static final String SEED = Settings.get("exchange", SelfCostBot.class.getSimpleName() + "_seed");
    public String bot_password;
    public String bot_address;
    private String domain;

    public SelfCostBot(String domain) {
        this.domain = domain;
        this.bot_password = Utils.hash(SEED + " " + domain);
        this.bot_address = Send.hashAddress(this.bot_password);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        }
    }

    @Override
    public void onTimer() throws Exception {
        CancelAll.request(this.domain, this.bot_address);
        double botGasBalance = Send.getBalanceOrZero("usdt", this.bot_address);
        double botTokenBalance = Send.getBalanceOrZero(this.domain, this.bot_address);
        LiquidityBot liquidityBot = LiquidityBot.liquidityBots.get(this.domain);
        Token token = Send.getToken(this.domain);
        double miningCostForToken = (double)token.difficulty.longValue() * Miner.minerFor100kHashes / 100000.0 + Miner.gasForOneMinting;
        double tokenCostPrice = Utils.round(miningCostForToken / Mint.calcMintRewardPerMin(this.domain, 20.0));
        double marketPrice = Place.getMarketPrice(this.domain);
        if (marketPrice < tokenCostPrice && botGasBalance > 0.0) {
            double gasAmount = Utils.round(botGasBalance / 10.0);
            Place.buy(this.domain, tokenCostPrice, gasAmount, this.bot_address);
            Send.request("usdt", this.bot_address, liquidityBot.bot_address, gasAmount, Send.tokenPass("usdt", this.bot_address, this.bot_password), null);
        } else if (marketPrice > tokenCostPrice && botTokenBalance > 0.0) {
            double tokenAmount = Utils.round(botTokenBalance / 10.0);
            Place.sell(this.domain, tokenCostPrice, tokenAmount, this.bot_address);
            Send.request(this.domain, this.bot_address, liquidityBot.bot_address, tokenAmount, Send.tokenPass(this.domain, this.bot_address, this.bot_password), null);
        }
    }
}

