/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.exchange.model;

import com.metabrain.gdb.model.chain.BigChainCell;
import com.metabrain.gdb.utils.Bytes;
import net.vavilon.utils.Utils;

public class Order
extends BigChainCell {
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_FILLED = 1;
    public static final int STATUS_CANCELED = -1;
    public long order_id;
    public String order_type;
    public String address;
    public String domain;
    public long is_sell;
    public double price;
    public double amount;
    public double total;
    public long status;
    public long timestamp;
    public double amount_filled;
    public double total_filled;

    public Order() {
    }

    public Order(String address, String domain, int isSell, double price, double amount, double total) {
        this.address = address;
        this.domain = domain;
        this.is_sell = isSell;
        this.price = price;
        this.amount = amount;
        this.total = total;
        this.status = 0L;
        this.timestamp = Utils.currentTimeSec();
        this.order_id = Utils.random();
    }

    public Order(String order_type, String address, String domain, long is_sell, double price, double amount, double total, long timestamp) {
        this.order_type = order_type;
        this.address = address;
        this.domain = domain;
        this.is_sell = is_sell;
        this.price = price;
        this.amount = amount;
        this.total = total;
        this.timestamp = timestamp;
    }

    public Order(Order order) {
        this.order_id = order.order_id;
        this.address = order.address;
        this.domain = order.domain;
        this.is_sell = order.is_sell;
        this.price = order.price;
        this.amount = order.amount;
        this.total = order.total;
        this.status = order.status;
        this.timestamp = order.timestamp;
        this.amount_filled = order.amount_filled;
        this.total_filled = order.total_filled;
    }

    @Override
    public byte[] build() {
        Bytes bytes = new Bytes(super.build());
        bytes.addLong(this.order_id);
        bytes.addString32(this.order_type);
        bytes.addString64(this.address);
        bytes.addString64(this.domain);
        bytes.addLong(this.is_sell);
        bytes.addDouble(this.price);
        bytes.addDouble(this.amount);
        bytes.addDouble(this.total);
        bytes.addLong(this.status);
        bytes.addLong(this.timestamp);
        bytes.addDouble(this.amount_filled);
        bytes.addDouble(this.total_filled);
        return bytes.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        super.parse(data);
        this.order_id = data.readLong();
        this.order_type = data.readString32();
        this.address = data.readString64();
        this.domain = data.readString64();
        this.is_sell = data.readLong();
        this.price = data.readDouble();
        this.amount = data.readDouble();
        this.total = data.readDouble();
        this.status = data.readLong();
        this.timestamp = data.readLong();
        this.amount_filled = data.readDouble();
        this.total_filled = data.readDouble();
    }
}

