/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.miner;

import com.metabrain.gdb.model.String64;
import net.vavilon.servers.model.Post;
import net.vavilon.token.Send;
import net.vavilon.token.model.Account;
import net.vavilon.utils.Request;
import org.exchange.miner.Miner;
import org.exchange.miner.MinerUtils;
import org.exchange.miner.model.MinerAccount;
import org.exchange.telegram.Telegram;
import org.exchange.telegram.utils.Format;

public class MinerSend
extends Post {
    @Override
    public void run() {
        String from = this.getRequired("from");
        String userAddress = this.getRequired("to");
        Double amount = this.getDouble("amount");
        String pass = this.getRequired("pass");
        if (amount == 0.0) {
            MinerUtils.error("amount is zero");
        }
        String minerPassword = MinerUtils.hash(MinerUtils.MINER_PASSWORD + userAddress);
        String minerAddress = Send.hashAddress(minerPassword);
        Send.regAccount("usdt", minerAddress, minerPassword);
        Send.request("usdt", from, minerAddress, amount, pass, null);
        MinerAccount minerAccount = MinerUtils.minerAccountsByAddress.get(userAddress);
        if (minerAccount == null || Send.getAccount("usdt", minerAccount.userAddress) == null) {
            minerAccount = new MinerAccount(userAddress, minerAddress, null, 1.0E-4);
            MinerUtils.minerAccountsByAddress.put(userAddress, minerAccount);
            MinerUtils.userAddressByMinerAddress.put(minerAddress, new String64(userAddress));
        }
        Miner.activeMinerAccountsByUserAddress.put(userAddress, minerAccount);
        Account account = Send.getAccount("usdt", minerAddress);
        Telegram.sendToAddress(minerAccount.userAddress, "you_have_received_energy", Request.map("amount", Format.formatAmount(amount * 100.0, null), "total", Format.formatAmount(account.balance, null), "from", Format.formatAddress(from), "txid", "" + this.time()));
    }

    @Override
    public void commit() {
    }

    public static void request(String from, String to, Double amount, String pass) {
        new MinerSend().run(null, Request.map("from", from, "to", to, "amount", amount, "pass", pass));
    }

    public static void deposit(String from, Double amount, String gas_pass) {
        MinerSend.request(from, from, amount, gas_pass);
    }
}

