/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.miner;

import com.metabrain.gdb.model.String64;
import net.vavilon.servers.model.Post;
import net.vavilon.token.Send;
import net.vavilon.utils.Request;
import org.exchange.miner.Miner;
import org.exchange.miner.MinerUtils;
import org.exchange.miner.model.MinerAccount;

public class ToggleDomain
extends Post {
    @Override
    public void run() {
        String minerAddress;
        String minerPassword;
        String domain = this.getRequired("domain");
        String address = this.getAddress("address");
        MinerAccount minerAccount = MinerUtils.minerAccountsByAddress.get(address);
        if (minerAccount == null) {
            minerPassword = MinerUtils.hash(MinerUtils.MINER_PASSWORD + address);
            minerAddress = Send.hashAddress(minerPassword);
            Send.regAccount("usdt", minerAddress, minerPassword);
            minerAccount = new MinerAccount(address, minerAddress, null, 1.0E-4);
        }
        if (minerAccount.toggleDomain(domain)) {
            minerPassword = MinerUtils.hash(MinerUtils.MINER_PASSWORD + address);
            minerAddress = Send.hashAddress(minerPassword);
            Send.regAccount(domain, minerAddress, minerPassword);
        }
        MinerUtils.minerAccountsByAddress.put(address, minerAccount);
        MinerUtils.userAddressByMinerAddress.put(minerAccount.minerAddress, new String64(address));
        Miner.activeMinerAccountsByUserAddress.put(address, minerAccount);
        Miner.calcMinerAccount(minerAccount);
    }

    @Override
    public void commit() {
    }

    public static void request(String domain, String address) {
        new ToggleDomain().run(null, Request.map("domain", domain, "address", address));
    }
}

