/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.telegram;

import com.metabrain.gdb.model.String64;
import java.util.ArrayList;
import java.util.List;
import net.vavilon.servers.model.Get;
import net.vavilon.token.Send;
import net.vavilon.utils.Bip39;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;
import org.exchange.telegram.Telegram;
import org.exchange.telegram.TelegramUtils;
import org.exchange.telegram.model.SubscriptionCheckResponse;
import org.exchange.telegram.model.TelegramRequest;
import org.exchange.telegram.model.TelegramUser;

public class Hook
extends Get {
    @Override
    public Get.Response get() {
        String body = this.getRequired("body");
        System.out.println(body);
        TelegramRequest request = (TelegramRequest)Utils.gson.fromJson(body, TelegramRequest.class);
        if (request.callback_query != null) {
            try {
                return this.handleCallbackQuery(request.callback_query);
            }
            catch (Exception exception) {
            }
        } else if (request.message != null && request.message.text != null) {
            return this.handleMessage(request);
        }
        return null;
    }

    private Get.Response handleMessage(TelegramRequest request) {
        TelegramRequest.Message message = request.message;
        String[] message_parts = request.message.text.split(" ");
        ResponseHook response = new ResponseHook();
        if (message_parts[0].equals("/start")) {
            String address;
            String[] referral_parts;
            response.method = "sendMessage";
            response.chat_id = message.chat.id;
            response.text = "\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c! \u0414\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0431\u043e\u0442\u0443 \u043f\u043e\u0434\u043f\u0438\u0448\u0438\u0442\u0435\u0441\u044c \u043d\u0430 \u043d\u0430\u0448 \u043a\u0430\u043d\u0430\u043b.";
            response.reply_markup = this.startButtons();
            Long userId = message.from.id;
            TelegramUser user = TelegramUtils.getUserByUserId(userId);
            if (user == null) {
                user = new TelegramUser();
            }
            if (user.registration_date == null) {
                user.registration_date = this.time();
            }
            user.id = userId;
            user.username = message.from.username;
            user.chat_id = message.chat.id;
            user.language_code = message.from.language_code;
            user.first_name = message.from.first_name;
            user.last_name = message.from.last_name;
            if (message_parts.length > 1 && Send.getToken((referral_parts = message_parts[1].split("_with_"))[0]) != null) {
                TelegramUser referral;
                String referral_username;
                user.referral_domain = referral_parts[0];
                String string = referral_username = referral_parts.length > 0 ? referral_parts[1] : "";
                if (Utils.isNotEmpty(referral_username) && Utils.isEmpty(user.referral_username) && !referral_username.equals(user.username) && (referral = TelegramUtils.getUserByUsername(referral_username)) != null) {
                    user.referral_username = referral_username;
                    ++user.referral_count;
                    Telegram.sendToUser(referral, "your_referral_logged_in", Utils.toMap(user), true);
                }
            }
            String seed = Bip39.getRandomSeed(message.chat.id, Bip39.ENG);
            String password = Utils.hash(seed);
            user.address = address = Send.hashAddress(password);
            TelegramUtils.usersByUserId.put("" + userId, user);
            TelegramUtils.userIdByAddress.put(address, new String64("" + userId));
            if (Utils.isNotEmpty(user.username)) {
                TelegramUtils.userIdByUsername.put(user.username, new String64("" + userId));
            }
        }
        return response;
    }

    ReplyMarkup startButtons() {
        ReplyMarkup markup = new ReplyMarkup();
        markup.addButton(new TgButton("1. \u041f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u043a\u0430\u043d\u0430\u043b", "https://t.me/vavilon_org_news", "url"));
        markup.addButton(new TgButton("2. \u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443", "check_sub", "callback_data"));
        return markup;
    }

    private Get.Response handleCallbackQuery(TelegramRequest.CallbackQuery callback_query) throws Exception {
        ResponseCallback response = new ResponseCallback();
        if (callback_query.data.equals("check_sub")) {
            response.method = "editMessageText";
            response.chat_id = callback_query.message.chat.id;
            response.message_id = callback_query.message.message_id;
            String responseStr = Request.post(Telegram.BOT_URL + "/getChatMember", Request.map("chat_id", "@vavilon_org_news", "user_id", callback_query.from.id));
            SubscriptionCheckResponse response1 = (SubscriptionCheckResponse)Utils.gson.fromJson(responseStr, SubscriptionCheckResponse.class);
            if (response1.isSubscribed()) {
                response.text = "\u2705\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0437\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 !\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 PLAY \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u0430 \u0432 \u043a\u043e\u0448\u0435\u043b\u0435\u043a.";
            } else {
                response.text = "\u274c\u0412\u044b \u0435\u0449\u0435 \u043d\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u044b \u043d\u0430 \u043a\u0430\u043d\u0430\u043b @ vavilon_org_news.\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043f\u0438\u0448\u0438\u0442\u0435\u0441\u044c \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.";
                response.reply_markup = this.startButtons();
            }
        }
        return response;
    }

    class ResponseHook
    extends Get.Response {
        String method;
        Long chat_id;
        String text;
        ReplyMarkup reply_markup;

        ResponseHook() {
        }
    }

    class ReplyMarkup {
        List<List<TgButton>> inline_keyboard = new ArrayList<List<TgButton>>();

        ReplyMarkup() {
        }

        void addButton(TgButton button) {
            ArrayList<TgButton> lineButton = new ArrayList<TgButton>();
            lineButton.add(button);
            this.inline_keyboard.add(lineButton);
        }
    }

    class TgButton {
        String text;
        String callback_data;
        String url;

        public TgButton(String text, String data, String type) {
            this.text = text;
            if (type.equals("callback_data")) {
                this.callback_data = data;
            } else if (type.equals("url")) {
                this.url = data;
            }
        }
    }

    class ResponseCallback
    extends Get.Response {
        String method;
        Long chat_id;
        Long message_id;
        String text;
        ReplyMarkup reply_markup;

        ResponseCallback() {
        }
    }
}

