/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.telegram;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.metabrain.gdb.BigFile;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import net.vavilon.Node;
import net.vavilon.utils.Request;
import net.vavilon.utils.Settings;
import net.vavilon.utils.Utils;
import org.exchange.airdrop.AirdropUtils;
import org.exchange.airdrop.model.Airdrop;
import org.exchange.telegram.TelegramUtils;
import org.exchange.telegram.model.TelegramUser;

public class Telegram {
    public static final String TOKEN = Settings.get("telegram", "token");
    public static final String BOT_URL = "https://api.telegram.org/bot" + TOKEN;
    public static final String TME = "https://t.me/";
    private static final String ADMIN_CHAT_ID = "331683369";
    public static final String ADMIN_ADDRESS = Settings.get("telegram", "admin_address");

    private static void send(String chatId, String template, String language, List<Object> data, boolean withNotification) {
        try {
            if (Utils.isNotEmpty(chatId) && Utils.isNotEmpty(template) && Node.isStarted) {
                File templateFile = new File("mfm-servers/message/" + template + "/" + language + ".mustache");
                if (!templateFile.exists()) {
                    templateFile = new File("mfm-servers/message/" + template + ".mustache");
                }
                if (!templateFile.exists()) {
                    return;
                }
                Mustache mustache = new DefaultMustacheFactory(templateFile.getParentFile()).compile(templateFile.getName());
                StringWriter writer = new StringWriter();
                String rendered = mustache.execute((Writer)writer, data).toString();
                if (BigFile.isDebugMode) {
                    chatId = ADMIN_CHAT_ID;
                }
                if (!TelegramUtils.isMessageSent(chatId, template, rendered)) {
                    Map<String, Object> params = Request.map("chat_id", chatId, "text", rendered, "disable_notification", withNotification ? "false" : "true");
                    String finalChatId = chatId;
                    Request.postAsync(BOT_URL + "/sendMessage", params, responseStr -> TelegramUtils.messageSent(finalChatId, template, rendered));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendToTokenChannel(String domain, String template, Object data) {
        Airdrop airdrop;
        if (Utils.isNotEmpty(domain) && Utils.isNotEmpty(template) && Node.isStarted && (airdrop = AirdropUtils.airdropByDomain.get(domain)) != null && Utils.isNotEmpty(airdrop.telegram)) {
            Telegram.send("@" + airdrop.telegram, template, airdrop.language, Utils.objectList(data), true);
        }
    }

    public static void sendToUser(TelegramUser user, String template, Object data, boolean withNotification) {
        if (user == null) {
            return;
        }
        Telegram.send("" + user.chat_id, template, user.language_code, Utils.objectList(user, data), withNotification);
    }

    public static void sendToAddress(String address, String template, Object data, boolean withNotification) {
        Telegram.sendToUser(TelegramUtils.getUserByAddress(address), template, data, withNotification);
    }

    public static void sendToAddress(String address, String template, Object data) {
        Telegram.sendToAddress(address, template, data, true);
    }

    public static void sendToAdmin(String address, String name, String value, String session) {
        Telegram.sendToAdmin(address, name, value, session, true);
    }

    public static void sendToAdmin(String address, String name, String value, String session, boolean withNotification) {
        Telegram.sendToAddress(ADMIN_ADDRESS, "session_analytics", Request.map("address", address, "name", name, "value", value, "session", session), withNotification);
    }

    public static String getChannelLanguage(String domain) {
        Airdrop airdrop = AirdropUtils.airdropByDomain.get(domain);
        if (airdrop == null) {
            return null;
        }
        return airdrop.language;
    }
}

