/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.telegram;

import com.metabrain.gdb.BigMap;
import com.metabrain.gdb.model.LongCell;
import com.metabrain.gdb.model.String64;
import java.util.HashMap;
import java.util.Map;
import net.vavilon.servers.model.Post;
import net.vavilon.utils.Utils;
import org.exchange.telegram.model.TelegramUser;

public abstract class TelegramUtils
extends Post {
    public static final String APP = "telegram";
    public static final BigMap<TelegramUser> usersByUserId = new BigMap<TelegramUser>("telegram", "usersByUserId", TelegramUser.class);
    protected static final BigMap<String64> userIdByAddress = new BigMap<String64>("telegram", "userIdByAddress", String64.class);
    protected static final BigMap<String64> userIdByUsername = new BigMap<String64>("telegram", "userIdBuUsername", String64.class);
    private static final BigMap<LongCell> sentMessages = new BigMap<LongCell>("telegram", "sentMessages", LongCell.class);
    public static final BigMap<LongCell> sentTemplates = new BigMap<LongCell>("telegram", "sentTemplates", LongCell.class);
    public static final String BOT_NAME = "vavilon_org_bot";
    public static final String NEWS_CHANNEL = "vavilon_org_news";
    Map<String, TelegramUser> newUsers = new HashMap<String, TelegramUser>();

    public static TelegramUser getUserByUserId(Long userId) {
        if (userId != null) {
            return usersByUserId.get("" + userId);
        }
        return null;
    }

    public static TelegramUser getUserByAddress(String address) {
        if (Utils.isEmpty(address)) {
            return null;
        }
        String64 userId = userIdByAddress.get(address);
        if (userId != null) {
            return usersByUserId.get(userId.toString());
        }
        return null;
    }

    public static TelegramUser getUserByUsername(String username) {
        if (Utils.isEmpty(username)) {
            return null;
        }
        String64 userId = userIdByUsername.get(username);
        if (userId != null) {
            return usersByUserId.get(userId.toString());
        }
        return null;
    }

    public void putUser(TelegramUser user) {
        if (user != null) {
            this.newUsers.put("" + user.id, user);
        }
    }

    public static boolean isMessageSent(String chatId, String template, String message) {
        return sentMessages.get(Utils.hash(chatId + ":" + template + "=" + message)) != null;
    }

    public static boolean isTemplateSent(String chatId, String template) {
        return sentMessages.get(Utils.hash(chatId + ":" + template)) != null;
    }

    public static void messageSent(String chatId, String template, String message) {
        sentMessages.put(Utils.hash(chatId + ":" + template + "=" + message), new LongCell(Utils.currentTimeSec()));
        sentTemplates.put(chatId + ":" + template, new LongCell(Utils.currentTimeSec()));
    }

    @Override
    public void commit() {
        for (TelegramUser user : this.newUsers.values()) {
            usersByUserId.put("" + user.id, user);
        }
        this.newUsers.clear();
    }
}

