/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.telegram.messages;

import java.util.List;
import net.vavilon.token.model.Account;
import net.vavilon.token.model.Token;
import org.exchange.telegram.messages.PriceAlert;
import org.exchange.telegram.model.Message;
import org.exchange.telegram.model.MessageFrequency;
import org.exchange.telegram.model.MessagePriority;
import org.exchange.telegram.model.TelegramUser;

public class DifficultyAlert {
    public static Message getMessage(TelegramUser user) {
        try {
            List<Account> accounts = PriceAlert.getTopSubAccounts(user.address);
            Account topAccount = DifficultyAlert.filterByDifficultyBorder(accounts);
            return DifficultyAlert.createMessage(topAccount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Account filterByDifficultyBorder(List<Account> accounts) {
        Account topAccount = null;
        for (Account account : accounts) {
            if (!(Math.abs(account.token.difficulty24) > DifficultyAlert.change24Border(account.token))) continue;
            topAccount = account;
        }
        return topAccount;
    }

    private static double change24Border(Token token) {
        if (token.difficulty > 10000000L) {
            return 10.0;
        }
        if (token.difficulty > 100000L) {
            return 30.0;
        }
        return 300.0;
    }

    private static Message createMessage(Account account) {
        if (account == null) {
            return null;
        }
        return new Message("difficulty_alert", MessagePriority.DAY_TIME, MessageFrequency.ONE_IN_24H, account.token);
    }
}

