/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.telegram.model;

import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;
import java.util.Calendar;
import net.vavilon.utils.Utils;
import org.exchange.telegram.Messages;

public class TelegramUser
implements BigArrayCell {
    public Long id;
    public String username;
    public Long chat_id;
    public String language_code;
    public long timezoneOffsetMinutes;
    public Long registration_date;
    public Long last_activity_date;
    public long visit_streak;
    public long max_visit_streak;
    public long total_visit_days;
    public long field2;
    public String first_name;
    public String last_name;
    public String address;
    public String last_created_token_domain;
    public String referral_domain;
    public String referral_username;
    public long referral_count;
    public double total_deposited;
    public double total_buy_energy;
    public double total_buy_exchange;
    public long deposit_count;
    public long buy_energy_count;
    public long buy_exchange_count;
    public String field3;
    public String field4;
    public String field5;

    @Override
    public byte[] build() {
        Bytes data = new Bytes();
        data.addLong(this.id);
        data.addString64(this.username);
        data.addLong(this.chat_id);
        data.addString8(this.language_code);
        data.addLong(this.timezoneOffsetMinutes);
        data.addLong(this.registration_date);
        data.addLong(this.last_activity_date);
        data.addLong(this.visit_streak);
        data.addLong(this.max_visit_streak);
        data.addLong(this.total_visit_days);
        data.addLong(this.field2);
        data.addString64(this.first_name);
        data.addString64(this.last_name);
        data.addString32(this.address);
        data.addString32(this.last_created_token_domain);
        data.addString32(this.referral_domain);
        data.addString32(this.referral_username);
        data.addLong(this.referral_count);
        data.addDouble(this.total_deposited);
        data.addDouble(this.total_buy_energy);
        data.addDouble(this.total_buy_exchange);
        data.addLong(this.deposit_count);
        data.addLong(this.buy_energy_count);
        data.addLong(this.buy_exchange_count);
        data.addString8(this.field3);
        data.addString64(this.field4);
        data.addString64(this.field5);
        return data.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        this.id = data.readLong();
        this.username = data.readString64();
        this.chat_id = data.readLong();
        this.language_code = data.readString8();
        this.timezoneOffsetMinutes = data.readLong();
        this.registration_date = data.readLong();
        this.last_activity_date = data.readLong();
        this.visit_streak = data.readLong();
        this.max_visit_streak = data.readLong();
        this.total_visit_days = data.readLong();
        this.field2 = data.readLong();
        this.first_name = data.readString64();
        this.last_name = data.readString64();
        this.address = data.readString32();
        this.last_created_token_domain = data.readString32();
        this.referral_domain = data.readString32();
        this.referral_username = data.readString32();
        this.referral_count = data.readLong();
        this.total_deposited = data.readDouble();
        this.total_buy_energy = data.readDouble();
        this.total_buy_exchange = data.readDouble();
        this.deposit_count = data.readLong();
        this.buy_energy_count = data.readLong();
        this.buy_exchange_count = data.readLong();
        this.field3 = data.readString8();
        this.field4 = data.readString64();
        this.field5 = data.readString64();
    }

    public void clear() {
        this.total_deposited = 0.0;
        this.total_buy_energy = 0.0;
        this.total_buy_exchange = 0.0;
        this.deposit_count = 0L;
        this.buy_energy_count = 0L;
        this.buy_exchange_count = 0L;
    }

    public Calendar getUserTime(long unixTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(unixTime * 1000L);
        if (this.timezoneOffsetMinutes != 0L) {
            calendar.setTimeZone(Messages.getTimeZoneIDFromOffset(this.timezoneOffsetMinutes));
        }
        return calendar;
    }

    public Object getUsername() {
        if (Utils.isNotEmpty(this.first_name)) {
            return this.first_name;
        }
        return "Superman";
    }
}

