/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb;

import com.metabrain.gdb.BigArray;
import com.metabrain.gdb.BigMap;
import com.metabrain.gdb.model.chain.BigChainCell;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class BigChain<Type extends BigChainCell>
extends BigMap<Type> {
    public BigArray<Type> history;

    public BigChain(String infinityFileID, Class<Type> valClass) {
        super(infinityFileID, valClass);
        this.history = new BigArray<Type>(infinityFileID + ".history", valClass);
    }

    public void addLast(String key, Type value) {
        BigChainCell lastItem = (BigChainCell)this.get(key);
        if (lastItem == null) {
            lastItem = (BigChainCell)this.values.createValInstance();
        } else {
            ((BigChainCell)value).prev_index = this.history.add(lastItem) + 1L;
        }
        ((BigChainCell)value).history_count = lastItem.history_count + 1L;
        ((BigChainCell)value).key = key;
        this.put(key, value);
    }

    public long getCount(String key) {
        BigChainCell lastItem = (BigChainCell)this.get(key);
        return lastItem == null ? 0L : lastItem.history_count;
    }

    public Type getLast(String key) {
        List<Type> last = this.getLastList(key, 1L);
        return (Type)(!last.isEmpty() ? (BigChainCell)last.get(0) : null);
    }

    public List<Type> getLastList(String key, Long size) {
        ArrayList<BigChainCell> result = new ArrayList<BigChainCell>();
        BigChainCell lastValue = (BigChainCell)this.get(key);
        if (lastValue == null) {
            return result;
        }
        result.add(lastValue);
        size = size - 1L;
        try {
            while (lastValue.prev_index != 0L && size > 0L) {
                lastValue = (BigChainCell)this.history.get(lastValue.prev_index - 1L);
                result.add(lastValue);
                Long l = size;
                size = size - 1L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void forEachFromEnd(String key, Consumer<Type> callback) {
        BigChainCell current = (BigChainCell)this.get(key);
        if (current == null) {
            return;
        }
        callback.accept(current);
        while (current.prev_index != 0L) {
            try {
                current = (BigChainCell)this.history.get(current.prev_index - 1L);
                callback.accept(current);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }
}

