/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb;

import com.metabrain.gdb.utils.Bytes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BigFile {
    final long BLOCK_SIZE = 0x400000L;
    private File dir;
    String fileName;
    public long fileSize = 0L;
    public Map<Integer, RandomAccessFile> blocks = new HashMap<Integer, RandomAccessFile>();
    protected Long maxBlocks = Long.MAX_VALUE;

    public BigFile(File parent, String fileName, Long maxBlocks) {
        this(parent, fileName);
        this.maxBlocks = maxBlocks;
        if (maxBlocks < 2L) {
            throw new NullPointerException();
        }
    }

    public BigFile(File parent, String fileName) {
        this.fileName = fileName;
        this.dir = parent;
        if (this.dir == null) {
            this.dir = new File("db");
        }
        this.dir.mkdir();
        this.calculateFileSize();
    }

    private void calculateFileSize() {
        this.fileSize = 0L;
        boolean needAddFirstBlockSize = false;
        int i = 0;
        while (true) {
            File blockFile;
            if ((blockFile = new File(this.dir, this.fileName + i + ".bin")).exists()) {
                try {
                    long blockSize = blockFile.length();
                    if (blockSize == 0L) {
                        if (i == 0) {
                            needAddFirstBlockSize = true;
                        } else {
                            blockSize = 0x400000L;
                        }
                    }
                    this.fileSize += blockSize;
                }
                catch (Exception exception) {}
            } else {
                if (!needAddFirstBlockSize) break;
                this.fileSize += 0x400000L;
                break;
            }
            ++i;
        }
    }

    RandomAccessFile getFile(int index) {
        RandomAccessFile blockRandomFile = this.blocks.get(index);
        if (blockRandomFile == null) {
            try {
                File blockFile = new File(this.dir, this.fileName + index + ".bin");
                blockRandomFile = new RandomAccessFile(blockFile, "rw");
                this.blocks.put(index, blockRandomFile);
                if ((long)this.blocks.size() > this.maxBlocks) {
                    Integer minBlockNumber = Collections.min(this.blocks.keySet());
                    try {
                        this.blocks.get(minBlockNumber).setLength(0L);
                        this.blocks.get(minBlockNumber).close();
                        this.blocks.remove(minBlockNumber);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return blockRandomFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(long start, long length) {
        BigFile bigFile = this;
        synchronized (bigFile) {
            long end = start + length;
            if (end > this.fileSize) {
                return null;
            }
            int startFileIndex = (int)(start / 0x400000L);
            int endFileIndex = (int)(end / 0x400000L);
            if (startFileIndex == endFileIndex) {
                RandomAccessFile readingFile = this.getFile(startFileIndex);
                int startInFile = (int)(start % 0x400000L);
                return this.readFromFile(readingFile, startInFile, (int)length);
            }
            RandomAccessFile firstFile = this.getFile(startFileIndex);
            RandomAccessFile secondFile = this.getFile(endFileIndex);
            int lengthInSecondFile = (int)(end % 0x400000L);
            int lengthInFirstFile = (int)(length - (long)lengthInSecondFile);
            int startInFirstFile = (int)(start % 0x400000L);
            int startInSecondFile = 0;
            byte[] dataFromFirstFile = this.readFromFile(firstFile, startInFirstFile, lengthInFirstFile);
            byte[] dataFromSecondFile = this.readFromFile(secondFile, startInSecondFile, lengthInSecondFile);
            return Bytes.concat(dataFromFirstFile, dataFromSecondFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long start, byte[] data) {
        BigFile bigFile = this;
        synchronized (bigFile) {
            long length = data.length;
            long end = start + length;
            if (start > this.fileSize) {
                return;
            }
            int startFileIndex = (int)(start / 0x400000L);
            int endFileIndex = (int)(end / 0x400000L);
            RandomAccessFile firstWriteFile = this.getFile(startFileIndex);
            RandomAccessFile secondWriteFile = this.getFile(endFileIndex);
            if (start == this.fileSize) {
                this.fileSize += (long)data.length;
            }
            if (startFileIndex == endFileIndex) {
                int startInFile = (int)(start - (long)startFileIndex * 0x400000L);
                this.whiteToFile(firstWriteFile, startInFile, data);
            } else {
                int lengthInSecondFile = (int)(end % 0x400000L);
                int lengthInFirstFile = (int)(length - (long)lengthInSecondFile);
                int startInFirstFile = (int)(start % 0x400000L);
                int startInSecondFile = 0;
                byte[] dataToFirstFile = new byte[lengthInFirstFile];
                byte[] dataToSecondFile = new byte[lengthInSecondFile];
                System.arraycopy(data, 0, dataToFirstFile, 0, lengthInFirstFile);
                System.arraycopy(data, lengthInFirstFile, dataToSecondFile, 0, lengthInSecondFile);
                this.whiteToFile(firstWriteFile, startInFirstFile, dataToFirstFile);
                this.whiteToFile(secondWriteFile, startInSecondFile, dataToSecondFile);
            }
        }
    }

    byte[] readFromFile(RandomAccessFile file, long offset, int length) {
        try {
            file.seek(offset);
            byte[] data = new byte[length];
            file.read(data);
            return data;
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    void whiteToFile(RandomAccessFile file, long offset, byte[] data) {
        try {
            file.seek(offset);
            file.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long add(byte[] data) {
        this.write(this.fileSize, data);
        return this.fileSize;
    }
}

