/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.vavilon.NodeInit;
import net.vavilon.analytics.Analytics;
import net.vavilon.contract.DataSet;
import net.vavilon.contract.Epoch;
import net.vavilon.contract.EpochFinish;
import net.vavilon.contract.MiningInfo;
import net.vavilon.contract.Mint10;
import net.vavilon.contract.Mint100;
import net.vavilon.contract.Mint20;
import net.vavilon.contract.PoolAdd;
import net.vavilon.contract.PoolImpact;
import net.vavilon.contract.PoolSwap;
import net.vavilon.contract.Stake;
import net.vavilon.contract.Staked;
import net.vavilon.contract.Unstake;
import net.vavilon.servers.WssClient;
import net.vavilon.servers.model.Endpoint;
import net.vavilon.servers.model.Message;
import net.vavilon.servers.model.Subscription;
import net.vavilon.storage.Copy;
import net.vavilon.token.AccountInfo;
import net.vavilon.token.Accounts;
import net.vavilon.token.AirdropTop;
import net.vavilon.token.GetTransaction;
import net.vavilon.token.RequestsHistory;
import net.vavilon.token.Search;
import net.vavilon.token.Send;
import net.vavilon.token.TokenEndpoint;
import net.vavilon.token.TokenInfo;
import net.vavilon.token.TokenUtils;
import net.vavilon.token.Transactions;
import net.vavilon.token.Version;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.exchange.tests.SimpleMiner;

public class Node
extends Analytics {
    public static boolean isDebugMode = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    public static String masterNode;
    public static boolean isStarted;

    public static void main(String[] args) throws Exception {
        String masterNode = null;
        if (args.length >= 1) {
            masterNode = args[0];
        }
        new Node(masterNode).start();
        new Scanner(System.in).hasNext();
    }

    public Node(String masterNode) throws Exception {
        Node.masterNode = masterNode;
        if (masterNode == null) {
            try {
                for (File file : new File("db").listFiles()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (masterNode == null) {
            new NodeInit();
        } else {
            this.load(masterNode);
        }
    }

    void load(String masterNode) {
        if (!new File("db/requests.json").exists()) {
            if (new File("requests.json").exists()) {
                this.commitRequests(Utils.readFile("requests.json"));
            } else if (!masterNode.equals("localhost")) {
                Request.get(masterNode + "/" + "db/requests.json", null, response -> this.commitRequests(response), response -> System.out.println("load error: " + masterNode + " " + response));
            }
        }
    }

    void commitRequests(String responseStr) {
        Response response = TokenUtils.gson.fromJson("{ history: [" + responseStr + "{}]}", Response.class);
        response.history.remove(response.history.size() - 1);
        for (Map<String, Object> params : response.history) {
            try {
                String path = (String)params.getOrDefault("path", "mfm-token/send");
                this.getEndpoint(path).run(path, params);
            }
            catch (Exception e) {
                System.err.println(TokenUtils.gson.toJson(params));
                e.printStackTrace();
                break;
            }
        }
    }

    void loadMining(String domain, String seed) {
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (TokenUtils.isEmpty(masterNode)) {
            Thread thread = new Thread(() -> new SimpleMiner("localhost", new String[]{"vavilon"}, "nation finger unable fade exist visa arch awake anchor surround paddle riot").start());
            thread.start();
            Thread.sleep(1000L);
            thread.interrupt();
        } else if (!masterNode.equals("localhost")) {
            new WssClient(masterNode, new WssClient.Callback(){

                @Override
                public void onOpen(Session session) {
                    session.sendText(TokenUtils.gson.toJson(new Subscription("requests")), new Callback(){

                        @Override
                        public void succeed() {
                        }
                    });
                }

                @Override
                public void onMessage(String message) {
                    Message msg = TokenUtils.gson.fromJson(message, Message.class);
                    if (msg.channel.equals("requests")) {
                        String path = (String)msg.data.getOrDefault("path", "");
                        Node.this.getEndpoint(path).run(path, msg.data);
                    }
                }
            });
        }
        isStarted = true;
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-token/version": {
                return new Version();
            }
            case "mfm-token/token": {
                return new TokenInfo();
            }
            case "mfm-token/send": {
                return new Send();
            }
            case "mfm-token/account": {
                return new AccountInfo();
            }
            case "mfm-token/accounts": {
                return new Accounts();
            }
            case "mfm-token/search": {
                return new Search();
            }
            case "mfm-token/top": {
                return new AirdropTop();
            }
            case "mfm-token/tran": {
                return new GetTransaction();
            }
            case "mfm-token/trans": {
                return new Transactions();
            }
            case "mfm-token/profile": {
                return new TokenEndpoint();
            }
            case "mfm-token/requests": {
                return new RequestsHistory();
            }
            case "mfm-contract/mint10": {
                return new Mint10();
            }
            case "mfm-contract/mint20": {
                return new Mint20();
            }
            case "mfm-contract/mint100": {
                return new Mint100();
            }
            case "mfm-contract/mining_info": {
                return new MiningInfo();
            }
            case "mfm-contract/data_set": {
                return new DataSet();
            }
            case "mfm-contract/stake": {
                return new Stake();
            }
            case "mfm-contract/staked": {
                return new Staked();
            }
            case "mfm-contract/unstake": {
                return new Unstake();
            }
            case "mfm-contract/pool_add": {
                return new PoolAdd();
            }
            case "mfm-contract/pool_swap": {
                return new PoolSwap();
            }
            case "mfm-contract/pool_impact": {
                return new PoolImpact();
            }
            case "mfm-contract/epoch_finish": {
                return new EpochFinish();
            }
            case "mfm-contract/epoch": {
                return new Epoch();
            }
            case "mfm-storage/copy": {
                return new Copy();
            }
        }
        return super.getEndpoint(uri);
    }

    static {
        isStarted = false;
    }

    public static class Response {
        public List<Map<String, Object>> history;
    }
}

