/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import net.vavilon.contract.Contract;
import net.vavilon.token.model.Account;

public class PoolAdd
extends Contract {
    public static String POOL_POSTFIX = "_pool";
    public String pool_password;
    public String pool_address;

    public String poolAddress(String domain) {
        if (this.pool_address == null) {
            this.pool_password = PoolAdd.hash(domain + POOL_POSTFIX);
            this.pool_address = PoolAdd.hashAddress(this.pool_password);
        }
        return this.pool_address;
    }

    public Double poolTokens(String domain) {
        Account tokens = PoolAdd.getAccount(domain, this.poolAddress(domain));
        return tokens == null ? 0.0 : tokens.balance;
    }

    public Double poolGas(String domain) {
        Account quote = PoolAdd.getAccount("usdt", this.poolAddress(domain));
        return quote == null ? 0.0 : quote.balance;
    }

    public Double poolPrice(String domain) {
        Double pollTokens = this.poolTokens(domain);
        Double poolGas = this.poolGas(domain);
        if (pollTokens == 0.0 || poolGas == 0.0) {
            return 1.0;
        }
        return poolGas / pollTokens;
    }

    public Double calculateSwap(String domain, Boolean isSell, Double amountIn) {
        amountIn = PoolAdd.round(amountIn);
        Double x = PoolAdd.round(this.poolTokens(domain));
        Double y = PoolAdd.round(this.poolGas(domain));
        Double k = PoolAdd.round(x * y);
        if (isSell.booleanValue()) {
            Double newX = PoolAdd.round(x + amountIn);
            Double newY = PoolAdd.round(k / newX);
            return PoolAdd.round(y - newY);
        }
        Double newY = PoolAdd.round(y + amountIn);
        Double newX = PoolAdd.round(k / newY);
        return PoolAdd.round(x - newX);
    }

    @Override
    public void run() {
        String domain = this.getRequired("domain");
        Double token_amount = this.getDoubleRequired("token_amount");
        String token_pass = this.getRequired("token_pass");
        String gas_address = this.getRequired("gas_address");
        String gas_pass = this.getRequired("gas_pass");
        String pool_address = this.poolAddress(domain);
        this.regAccount(this.scriptPath, "usdt", pool_address, this.pool_password, "mfm-contract/pool_swap");
        this.regAccount(this.scriptPath, domain, pool_address, this.pool_password, "mfm-contract/pool_swap");
        this.tokenSend(this.scriptPath, "usdt", gas_address, pool_address, PoolAdd.round(this.poolPrice(domain) * token_amount), gas_pass, null);
        this.tokenSend(this.scriptPath, domain, gas_address, pool_address, token_amount, token_pass, null);
    }
}

