/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.contract;

import net.vavilon.token.TokenUtils;
import net.vavilon.token.model.Transaction;

public class Stake
extends TokenUtils {
    public static final String STAKING_ADDRESS = "cba1ac1c73a9d6b717484e774ff85845d343713580cc46b9ae57f801aef729d3";
    public static final double STAKING_PERCENT = 10.0;
    public static final int STAKING_PERIOD_DAYS = 30;

    @Override
    public void run() {
        String domain = this.getString("domain");
        String address = this.getRequired("address");
        String pass = this.getRequired("pass");
        Double amount = this.getDoubleRequired("amount");
        Transaction lastStake = Stake.getTranLast(address, STAKING_ADDRESS);
        Transaction lastUnstake = Stake.getTranLast(STAKING_ADDRESS, address);
        if (lastStake != null && lastUnstake != null && lastStake.time > lastUnstake.time) {
            Stake.error("You need to unstake first");
        }
        double nextPayOff = (double)Math.round(amount * 1.1 * 100.0) / 100.0;
        if (Stake.getBalance(domain, STAKING_ADDRESS) < nextPayOff) {
            Stake.error("Not enough funds in staking address");
        }
        this.tokenSend(this.scriptPath, domain, address, STAKING_ADDRESS, amount, pass, null);
        this.response.put("staked", amount);
    }
}

