/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.servers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.vavilon.servers.model.Message;
import net.vavilon.servers.model.Subscription;
import net.vavilon.utils.Utils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class WssServer {
    private final Callback callback;
    public static final Map<String, HashSet<Session>> channels = new HashMap<String, HashSet<Session>>();

    public WssServer(Callback callback) {
        this.callback = callback;
    }

    @OnWebSocketMessage
    public void onWebSocketText(Session session, String message) {
        Subscription sub = Utils.gson.fromJson(message, Subscription.class);
        if (sub.subscribe != null) {
            if (!channels.containsKey(sub.subscribe)) {
                channels.put(sub.subscribe, new HashSet());
            }
            if (this.callback != null) {
                this.callback.onMessage(sub);
            }
            channels.get(sub.subscribe).add(session);
            System.out.println("subscribe: " + sub.subscribe);
        } else if (sub.unsubscribe != null && channels.containsKey(sub.unsubscribe)) {
            channels.get(sub.unsubscribe).remove(this);
        }
    }

    public static void broadcast(String channel, Object data) {
        if (channels.containsKey(channel)) {
            String message = Utils.gson.toJson(new Message(channel, Utils.toMap(data)));
            Iterator<Session> iterator = channels.get(channel).iterator();
            while (iterator.hasNext()) {
                Session conn = iterator.next();
                if (conn.isOpen()) {
                    conn.sendText(message, null);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public static interface Callback {
        public void onMessage(Subscription var1);
    }
}

