/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.tests;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.vavilon.utils.Success;
import net.vavilon.utils.Utils;
import net.vavilon.utils.Wallet;

public class TPS {
    static Integer success = 0;
    static Integer error = 0;
    static Long start = 0L;

    public static Map<String, String> generateAccounts(int numberOfAccounts) {
        HashMap<String, String> accounts = new HashMap<String, String>();
        Random random = new Random();
        for (int i = 0; i < numberOfAccounts; ++i) {
            accounts.put("test" + random.nextInt(100000), "" + random.nextInt(100000));
        }
        return accounts;
    }

    public static void startSendingRequests(Map<String, String> accounts, Success success, Success error) throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(accounts.keySet().size());
        for (String address : accounts.keySet()) {
            Thread.sleep(new Random().nextInt(1000));
            String password = accounts.get(address);
            executor.submit(() -> {
                while (true) {
                    Wallet.send("https://mytoken.space:8011", address, password, "usdt", address, "0", success, error);
                }
            });
        }
    }

    public static void main(String[] args) throws Exception {
        start = Utils.timeSec();
        Utils.disableCertificateValidation();
        TPS.startSendingRequests(TPS.generateAccounts(20), response -> {
            success = success + 1;
            System.out.println("TPS success " + success + " error " + error + " avg " + (long)(success + error) / (Utils.timeSec() - start));
        }, response -> {
            error = error + 1;
            System.out.println("TPS error " + error + " success " + success);
        });
    }
}

