/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.token;

import com.metabrain.gdb.BigArray;
import com.metabrain.gdb.BigChain64;
import com.metabrain.gdb.BigMap;
import com.metabrain.gdb.model.String1024;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.vavilon.Node;
import net.vavilon.analytics.AnalyticsUtils;
import net.vavilon.servers.WssServer;
import net.vavilon.token.model.Account;
import net.vavilon.token.model.DepositListener;
import net.vavilon.token.model.SearchList;
import net.vavilon.token.model.Token;
import net.vavilon.token.model.Transaction;
import net.vavilon.utils.Base58;
import net.vavilon.utils.Request;
import net.vavilon.utils.Top;

public abstract class TokenUtils
extends AnalyticsUtils {
    public static final String GENESIS_ADDRESS = "owner";
    public static final String ADDRESS_CHARS = "abcdef0123456789";
    public static final String DOMAIN_CHARS = "abcdefghijklmnopqrstuvwxyz_";
    public static final String REQUESTS_FILENAME = "db/requests.json";
    public static final BigArray<String1024> requests = new BigArray<String1024>("requests", String1024.class);
    public static final BigMap<Transaction> transByHash = new BigMap<Transaction>("transByHash", Transaction.class);
    public static final BigMap<Token> tokensByDomain = new BigMap<Token>("tokensByDomain", Token.class);
    private static final BigMap<Account> accounts = new BigMap<Account>("accounts", Account.class);
    protected static final BigMap<SearchList> tokensSearch = new BigMap<SearchList>("tokensSearch", SearchList.class);
    public static final BigChain64 userDomains = new BigChain64("userDomains");
    public static final BigChain64 userTrans = new BigChain64("userTrans");
    private static final BigChain64 fromToTrans = new BigChain64("fromToTrans");
    public static final Top<Token> topMining = new Top<Token>("topMining", Token.class, (t1, t2) -> Long.compare(t2.difficulty, t1.difficulty), 10);
    public static final List<DepositListener> depositListeners = new ArrayList<DepositListener>();
    public Map<String, Account> accountsNew = new ConcurrentHashMap<String, Account>();
    public List<Transaction> transactionsNew = new ArrayList<Transaction>();
    public List<Token> tokensNew = new ArrayList<Token>();

    public static String tokenKey(String domain, String address, String password, String prevKey) {
        return TokenUtils.hash(domain + address + password + (prevKey == null ? "" : prevKey));
    }

    public static String tokenNextHash(String domain, String address, String password, String prevKey) {
        return TokenUtils.hash(TokenUtils.tokenKey(domain, address, password, prevKey));
    }

    public static String tokenStartPass(String domain, String address, String password) {
        return ":" + TokenUtils.tokenNextHash(domain, address, password, "");
    }

    public static String tokenPass(String domain, String address, String password, String prevKey) {
        String key = TokenUtils.tokenKey(domain, address, password, prevKey);
        String nextHash = TokenUtils.tokenNextHash(domain, address, password, key);
        return key + ":" + nextHash;
    }

    public static String tokenPass(String domain, String address, String password) {
        Account account = TokenUtils.getAccount(domain, address);
        return TokenUtils.tokenPass(domain, address, password, account == null ? null : (account.prev_key == null ? "" : account.prev_key));
    }

    protected String tokenPassCached(String domain, String address, String password) {
        Account account = this.getAccountChanced(domain, address);
        return TokenUtils.tokenPass(domain, address, password, account == null ? null : (account.prev_key == null ? "" : account.prev_key));
    }

    private void setTran(Transaction tran) {
        this.transactionsNew.add(tran);
    }

    public static Token getToken(String domain) {
        Token token = tokensByDomain.get(domain);
        if (token != null) {
            token = token.clone();
        }
        return token;
    }

    public void setToken(Token token) {
        this.tokensNew.add(token);
    }

    public static Account getAccount(String domain, String address) {
        return accounts.get(domain + address);
    }

    protected Account getAccountChanced(String domain, String address) {
        Account account = this.accountsNew.get(domain + address);
        if (account == null) {
            account = TokenUtils.getAccount(domain, address);
        }
        return account;
    }

    private void setAccountCached(Account account) {
        this.accountsNew.put(account.domain + account.address, account);
    }

    public List<Account> getSubAccounts(String address) {
        ArrayList<Account> result = new ArrayList<Account>();
        List<String> domains = userDomains.getLastStringList(address, 20L);
        for (String domain : domains) {
            Account account = TokenUtils.getAccount(domain, address);
            if (account == null) continue;
            account.token = TokenUtils.getToken(domain);
            result.add(account);
        }
        return result;
    }

    public void validateDomain(String domain) {
        if (domain == null) {
            TokenUtils.error("domain is null");
        }
        if (domain.length() < 3 || domain.length() > 64) {
            TokenUtils.error("domain length has to be between 3 and 64");
        }
        if (!this.isValidChars(domain, DOMAIN_CHARS)) {
            TokenUtils.error("domain has to contain only english letters and underscore");
        }
    }

    public boolean validateAddress(String address) {
        if (address == null) {
            TokenUtils.error("address is null");
        }
        if (!address.startsWith("V")) {
            TokenUtils.error("first symbol in address has to be V");
        }
        if (Base58.decode(address.substring(1)).length != 20) {
            TokenUtils.error("after base58 decode size has to be 20");
        }
        return true;
    }

    protected static List<String> getTranIds(String firstAddress, String secondAddress, Long size) {
        return fromToTrans.getLastStringList(TokenUtils.sortAndMerge(firstAddress, secondAddress), size);
    }

    public static List<Transaction> getTrans(String from, String to, Long size) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (String next_hash : TokenUtils.getTranIds(from, to, size)) {
            Transaction tran = transByHash.get(next_hash);
            result.add(tran);
        }
        return result;
    }

    public static List<Transaction> getTransByDomain(String from, String to, String domain, Long size) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (String next_hash : TokenUtils.getTranIds(from, to, 20L)) {
            Transaction tran = transByHash.get(next_hash);
            if (tran.domain.equals(domain)) {
                result.add(tran);
            }
            if ((long)result.size() != size) continue;
            return result;
        }
        return result;
    }

    public static Transaction getTranLast(String from, String to) {
        List<Transaction> trans = TokenUtils.getTrans(from, to, 1L);
        if (trans.size() > 0) {
            return trans.get(0);
        }
        return null;
    }

    protected static List<String> getUserTranIds(String address, Long size) {
        return userTrans.getLastStringList(address, size);
    }

    protected static List<Transaction> getUserTrans(String address, Long size) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (String next_hash : TokenUtils.getUserTranIds(address, size)) {
            Transaction tran = transByHash.get(next_hash);
            result.add(tran);
        }
        return result;
    }

    protected static List<Transaction> getUserTransByDomains(String address, Long size, String domain) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (String next_hash : TokenUtils.getUserTranIds(address, size)) {
            Transaction tran = transByHash.get(next_hash);
            if (!tran.domain.equals(domain)) continue;
            result.add(tran);
        }
        return result;
    }

    protected static Transaction getUserTranLast(String address) {
        List<Transaction> trans = TokenUtils.getUserTrans(address, 1L);
        if (trans.size() > 0) {
            return trans.get(0);
        }
        return null;
    }

    public static Double getBalance(String domain, String address) {
        Account account = TokenUtils.getAccount(domain, address);
        return account != null ? account.balance : null;
    }

    public static double getBalanceOrZero(String domain, String address) {
        Double balance = TokenUtils.getBalance(domain, address);
        return balance != null ? balance : 0.0;
    }

    protected String tokenSend(String scriptPath, String domain, String from_address, String to_address, Double amount, String pass, String delegate) {
        String next_hash;
        if (from_address.equals(to_address) && amount != 0.0) {
            TokenUtils.error("from address and to address are the same");
        }
        if (amount - TokenUtils.round(amount) != 0.0) {
            TokenUtils.error("max amount decimals is 4");
        }
        if (amount < 0.0) {
            TokenUtils.error("amount less than 0");
        }
        if (scriptPath == null) {
            TokenUtils.error("script path null");
        }
        this.validateAddress(to_address);
        String key = pass != null ? pass.split(":")[0] : null;
        String string = next_hash = pass != null ? pass.split(":")[1] : null;
        if (from_address.equals(GENESIS_ADDRESS) && TokenUtils.isNotEmpty(key)) {
            TokenUtils.error("when you create account key has to be empty");
        }
        if (from_address.equals(GENESIS_ADDRESS)) {
            this.validateDomain(domain);
            if (TokenUtils.getAccount(domain, GENESIS_ADDRESS) == null) {
                Account owner = new Account();
                owner.domain = domain;
                owner.address = GENESIS_ADDRESS;
                owner.prev_key = "";
                owner.next_hash = "";
                owner.balance = amount;
                owner.delegate = "mfm-token/send";
                this.setAccountCached(owner);
                if (amount > 0.0) {
                    this.setToken(new Token(domain, amount));
                    this.trackAccumulate("tokens_count");
                }
            }
            if (TokenUtils.getAccount(domain, to_address) == null) {
                Account to = new Account();
                to.domain = domain;
                to.address = to_address;
                to.prev_key = "";
                to.next_hash = next_hash;
                to.balance = 0.0;
                to.delegate = delegate;
                this.setAccountCached(to);
            } else {
                TokenUtils.error("account exists");
            }
        } else {
            this.validateAddress(from_address);
        }
        Account from = this.getAccountChanced(domain, from_address);
        Account to = this.getAccountChanced(domain, to_address);
        if (from == null) {
            this.error("sender does not exist", from_address);
        }
        if (from.balance < amount) {
            this.error("balance is not enough", from);
        }
        if (to == null) {
            this.error("receiver does not exist", to_address);
        }
        if (from.delegate != null) {
            if (!from.address.equals(GENESIS_ADDRESS) && !from.delegate.equals(scriptPath)) {
                this.error("only delegated script can use account", from);
            }
        } else if (!from.next_hash.equals(TokenUtils.hash(key))) {
            this.error("access denied", from);
        }
        String prev_hash = from.next_hash;
        from.prev_key = key;
        from.next_hash = next_hash;
        from.balance = TokenUtils.round(from.balance - amount);
        this.setAccountCached(from);
        if (!from_address.equals(to_address)) {
            to.balance = TokenUtils.round(to.balance + amount);
            this.setAccountCached(to);
        }
        this.setTran(new Transaction(domain, from_address, to_address, amount, key, next_hash, prev_hash, delegate, this.time()));
        return next_hash;
    }

    public void regAccount(String scriptPath, String domain, String address, String password, String delegate) {
        if (TokenUtils.getAccount(domain, address) == null) {
            this.tokenSend(scriptPath, domain, GENESIS_ADDRESS, address, 0.0, TokenUtils.tokenStartPass(domain, address, password), delegate);
        }
    }

    public void changePass(String scriptPath, String domain, String address, String pass) {
        this.tokenSend(scriptPath, domain, address, address, 0.0, pass, null);
    }

    @Override
    public void commit() {
        this.commitTrans();
        this.commitAccounts();
        this.commitTokens();
        super.commit();
        this.depositSuccess();
    }

    public void commitTokens() {
        for (Token token : this.tokensNew) {
            if (token.created == 0L) {
                token.created = this.time();
                if (token.domain.equals("usdt")) {
                    token.price = 1.0;
                    token.price24 = 0.0;
                }
                this.putDomainToSearchIndex(token.domain);
                System.out.println("token created " + token.domain);
            }
            tokensByDomain.put(token.domain, token);
            topMining.add(token);
        }
        this.tokensNew.clear();
    }

    public void putDomainToSearchIndex(String domain) {
        for (int i = 1; i < domain.length(); ++i) {
            String substr = domain.substring(0, i + 1);
            SearchList searchList = tokensSearch.get(substr);
            if (searchList == null) {
                searchList = new SearchList();
            }
            searchList.add(domain);
            tokensSearch.put(substr, searchList);
        }
    }

    public void commitTrans() {
        try {
            if (this.transactionsNew.size() > 0) {
                this.getRequired("domain");
            }
            Collections.reverse(this.transactionsNew);
            for (Transaction tran : this.transactionsNew) {
                transByHash.put(tran.next_hash, tran);
            }
            for (Transaction tran : this.transactionsNew) {
                fromToTrans.addLast(tran.from + tran.to, tran.next_hash);
                userTrans.addLast(tran.from, tran.next_hash);
                userTrans.addLast(tran.to, tran.next_hash);
                WssServer.broadcast("account:" + tran.from, tran);
                WssServer.broadcast("account:" + tran.to, tran);
                WssServer.broadcast("transactions", tran);
                if (tran.from.equals(GENESIS_ADDRESS)) continue;
                this.trackAccumulate(tran.domain + "_trans");
            }
            this.trackAccumulate("trans_count", this.transactionsNew.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commitAccounts() {
        int newAccountsCount = 0;
        for (Account account : this.accountsNew.values()) {
            if (TokenUtils.isEmpty(account.prev_key) && TokenUtils.isEmpty(account.delegate)) {
                this.trackAccumulate(account.domain + "_accounts");
            }
            if (!accounts.containsKey(account.domain + account.address) && !account.address.equals(GENESIS_ADDRESS)) {
                ++newAccountsCount;
                userDomains.addLast(account.address, account.domain);
            }
            accounts.put(account.domain + account.address, account);
        }
        this.trackAccumulate("accounts_count", newAccountsCount);
        this.accountsNew.clear();
    }

    private void depositSuccess() {
        if (this.transactionsNew.size() > 0) {
            String paramsJson = gson.toJson(this.params);
            requests.add(new String1024(paramsJson));
            TokenUtils.appendFile(REQUESTS_FILENAME, paramsJson + ",");
            if (Node.isStarted) {
                WssServer.broadcast("requests", this.params);
                if (TokenUtils.isNotEmpty(Node.masterNode) && !Node.masterNode.equals("localhost")) {
                    Request.postAsync(Node.masterNode + "/" + this.params.get("path"), new HashMap<String, Object>(this.params), response -> System.out.println(), response -> System.out.println());
                }
            }
            for (Transaction tran : this.transactionsNew) {
                for (DepositListener depositListener : depositListeners) {
                    try {
                        depositListener.run(tran);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.transactionsNew.clear();
        }
    }

    @Override
    protected void beforeRun() {
        this.params.put("time", this.params.getOrDefault("time", "" + this.time()));
        if (!Node.isStarted) {
            this.emulateTime(this.getLong("time"));
        }
    }
}

