/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import java.util.Timer;
import java.util.TimerTask;

public class InfiniteTimer {
    Timer timer;
    Callback callback;
    public final long periodMs;
    public final long stopAfterMs;
    long lastRestart = 0L;

    public InfiniteTimer(Callback callback, long periodMs) {
        this(callback, periodMs, Long.MAX_VALUE);
    }

    public InfiniteTimer(Callback callback, long periodMs, long stopAfterMs) {
        this.callback = callback;
        this.periodMs = periodMs;
        this.stopAfterMs = stopAfterMs;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void start() {
        this.stop();
        this.lastRestart = System.currentTimeMillis();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - InfiniteTimer.this.lastRestart < InfiniteTimer.this.stopAfterMs) {
                    try {
                        InfiniteTimer.this.callback.onTimer();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    InfiniteTimer.this.timer.cancel();
                    InfiniteTimer.this.timer = null;
                }
            }
        }, this.periodMs, this.periodMs);
    }

    public void restart() {
        if (this.lastRestart == 0L || System.currentTimeMillis() - this.lastRestart >= this.stopAfterMs) {
            this.start();
        } else {
            this.lastRestart = System.currentTimeMillis();
        }
    }

    public static interface Callback {
        public void onTimer();
    }
}

