/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import net.vavilon.utils.Base64;

public class LimitCpu {
    AtomicLong counter = new AtomicLong();

    LimitCpu(Runnable task, double loadPercent) throws InterruptedException {
        ArrayList<Thread> list = new ArrayList<Thread>();
        for (int i = 0; i < 40; ++i) {
            Thread thread = new Thread(() -> {
                while (true) {
                    task.run();
                    if (Thread.interrupted()) break;
                    this.counter.incrementAndGet();
                }
            });
            thread.start();
            list.add(thread);
        }
        Thread.sleep(10000L);
        this.counter.set(0L);
        ArrayList<Long> counters = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            long count = this.counter.get();
            counters.add(count);
            System.out.println("count " + count);
            this.counter.set(0L);
        }
        for (Thread thread : list) {
            thread.interrupt();
        }
        list.clear();
        long avgCount = counters.stream().mapToLong(Long::longValue).sum() / (long)counters.size();
        long targetCount = (long)((double)avgCount * loadPercent / 100.0);
        System.out.println("avgCount " + avgCount);
        System.out.println("targetCount " + targetCount);
        for (int i = 0; i < 40; ++i) {
            Thread thread = new Thread(() -> {
                while (true) {
                    task.run();
                    if (Thread.interrupted()) break;
                    this.counter.incrementAndGet();
                }
            });
            list.add(thread);
            thread.start();
            Thread.sleep(5000L);
            long count = this.counter.incrementAndGet();
            System.out.println("count " + count / 5L);
            if (count > targetCount * 5L) {
                System.out.println("thread count " + (i + 1));
                break;
            }
            this.counter.set(0L);
        }
        Thread.sleep(20000L);
        for (Thread thread : list) {
            thread.interrupt();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        new LimitCpu(() -> {
            try {
                String filename = "src/test/resources/test_md5.txt";
                String checksum = "5EB63BBBE01EEED093CB22BB8F5ACDC3";
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(filename.getBytes());
                byte[] digest = md.digest();
                String string = Base64.encode(digest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 40.0);
    }
}

