/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

public class LimitThread {
    private final Runnable task;
    private final Counter everySec;
    private final long sleepMsPerSec;
    public static long counter = 0L;

    public LimitThread(Runnable task, Counter everySec, double loadPercent) {
        this.task = task;
        this.everySec = everySec;
        this.sleepMsPerSec = (long)(1000.0 * (1.0 - loadPercent / 100.0));
    }

    public void start() {
        new Thread(() -> {
            while (true) {
                long startTime = System.currentTimeMillis();
                try {
                    Thread.sleep(this.sleepMsPerSec);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                long runCount = 0L;
                do {
                    this.task.run();
                    ++runCount;
                } while (System.currentTimeMillis() - startTime <= 1000L);
                if (this.everySec == null) continue;
                this.everySec.everySec(runCount);
            }
        }).start();
    }

    public static void main(String[] args) {
        new LimitThread(() -> ++counter, runCount -> {}, 100.0).start();
    }

    static interface Counter {
        public void everySec(long var1);
    }
}

