/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import com.google.gson.Gson;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.vavilon.utils.StringUtils;
import net.vavilon.utils.Success;

public class Request {
    public static Gson gson = new Gson();

    public static Map<String, Object> map(Object ... params) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of parameters. Parameters should be in key-value pairs.");
        }
        for (int i = 0; i < params.length; i += 2) {
            if (!(params[i] instanceof String)) {
                throw new IllegalArgumentException("Keys should be of type String.");
            }
            paramMap.put((String)params[i], params[i + 1]);
        }
        return paramMap;
    }

    public static void post(String redirectUrl) {
        Request.post(redirectUrl, null, null, null);
    }

    public static void post(String redirectUrl, Map<String, Object> params) {
        Request.post(redirectUrl, params, null, null);
    }

    public static void post(String redirectUrl, Map<String, Object> params, Success success) {
        Request.post(redirectUrl, params, success, null);
    }

    public static void post(String redirectUrl, Map<String, Object> params, Success success, Success error) {
        Request.request("POST", redirectUrl, params, success, error);
    }

    public static void get(String redirectUrl) {
        Request.get(redirectUrl, null, null, null);
    }

    public static void get(String redirectUrl, Map<String, Object> params) {
        Request.get(redirectUrl, params, null, null);
    }

    public static void get(String redirectUrl, Map<String, Object> params, Success success) {
        Request.get(redirectUrl, params, success, null);
    }

    public static void get(String redirectUrl, Map<String, Object> params, Success success, Success error) {
        Request.request("GET", redirectUrl, params, success, error);
    }

    public static void postAsync(String redirectUrl) {
        new Thread(() -> Request.post(redirectUrl)).start();
    }

    public static void postAsync(String redirectUrl, Map<String, Object> params) {
        new Thread(() -> Request.post(redirectUrl, params)).start();
    }

    public static void postAsync(String redirectUrl, Map<String, Object> params, Success success) {
        new Thread(() -> Request.post(redirectUrl, params, success)).start();
    }

    public static void postAsync(String redirectUrl, Map<String, Object> params, Success success, Success error) {
        new Thread(() -> Request.post(redirectUrl, params, success, error)).start();
    }

    public static void getAsync(String redirectUrl) {
        new Thread(() -> Request.get(redirectUrl)).start();
    }

    public static void getAsync(String redirectUrl, Map<String, Object> params) {
        new Thread(() -> Request.get(redirectUrl, params)).start();
    }

    public static void getAsync(String redirectUrl, Map<String, Object> params, Success success) {
        new Thread(() -> Request.get(redirectUrl, params, success)).start();
    }

    public static void getAsync(String redirectUrl, Map<String, Object> params, Success success, Success error) {
        new Thread(() -> Request.get(redirectUrl, params, success, error)).start();
    }

    private static void request(String method, String redirectUrl, Map<String, Object> params, Success success, Success error) {
        block13: {
            System.out.println("request: " + redirectUrl + "\n" + gson.toJson(params));
            try {
                int responseCode;
                if (redirectUrl == null) {
                    return;
                }
                if (!redirectUrl.contains("://")) {
                    redirectUrl = redirectUrl.contains("localhost") ? "http://" + redirectUrl : "https://" + redirectUrl;
                }
                if ("GET".equals(method) && params != null && !params.isEmpty()) {
                    StringBuilder urlBuilder = new StringBuilder(redirectUrl);
                    urlBuilder.append(redirectUrl.contains("?") ? "&" : "?");
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        urlBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode((String)entry.getValue(), "UTF-8")).append("&");
                    }
                    redirectUrl = urlBuilder.substring(0, urlBuilder.length() - 1);
                }
                URL url = new URL(redirectUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod(method);
                conn.setConnectTimeout(3000);
                if ("POST".equals(method)) {
                    conn.setDoOutput(true);
                    if (params != null) {
                        String paramsStr = gson.toJson(params);
                        byte[] byteData = paramsStr.getBytes("UTF-8");
                        conn.setRequestProperty("Content-Type", "application/json");
                        conn.setRequestProperty("Content-Length", "" + byteData.length);
                        conn.getOutputStream().write(byteData, 0, byteData.length);
                    }
                }
                if ((responseCode = conn.getResponseCode()) == 200) {
                    if (success != null) {
                        success.run(StringUtils.convertToString(conn.getInputStream()));
                    }
                } else {
                    String response = StringUtils.convertToString(conn.getErrorStream());
                    if (error != null) {
                        error.run(response);
                    } else {
                        System.out.println(redirectUrl);
                        System.out.println(response);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (error == null) break block13;
                error.run(e.getMessage());
            }
        }
    }
}

