/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.vavilon.utils.Base58;
import net.vavilon.utils.Base64;
import net.vavilon.utils.SHA256;

public class Utils {
    public static final Random random = new Random();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final long WEEK_SEC = 604800L;
    Long emulatedTime = null;

    public static String hash(String input) {
        return SHA256.hash(input);
    }

    public static String hashAddress(String password) {
        return Utils.address(Utils.hash(password));
    }

    public static String address(String addressBase64) {
        byte[] hash = Base64.decode(addressBase64);
        byte[] addressBytes = new byte[20];
        System.arraycopy(hash, hash.length - 20, addressBytes, 0, 20);
        return "V" + Base58.encode(addressBytes);
    }

    public static Double round(Double value) {
        return (double)Math.round(value * Math.pow(10.0, 4.0)) / Math.pow(10.0, 4.0);
    }

    public static Double roundDown(Double value) {
        if (value == null) {
            return null;
        }
        double scale = Math.pow(10.0, 4.0);
        return Math.floor(value * scale) / scale;
    }

    public static int random() {
        return Math.abs(random.nextInt());
    }

    public void emulateTime(Long time) {
        this.emulatedTime = time;
    }

    public Long time() {
        if (this.emulatedTime != null) {
            return this.emulatedTime;
        }
        return Utils.timeSec();
    }

    public static Long timeSec() {
        return (long)Math.ceil((double)new Date().getTime() / 1000.0);
    }

    public static Map<String, Object> toMap(Object obj) {
        return (Map)gson.fromJson(gson.toJson(obj), new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static Map<String, Object> toMap(String string) {
        return (Map)gson.fromJson(string, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static String readFile(String path) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(encoded);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void writeFile(String path, String string) {
        try {
            Files.write(Paths.get(path, new String[0]), string.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void appendFile(String path, String responseStr) {
        try {
            FileWriter errorLog = new FileWriter(path, true);
            errorLog.write(responseStr);
            errorLog.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(String filePath) {
        try {
            Files.delete(Paths.get(filePath, new String[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(String source, String dest) {
        try {
            Files.copy(Paths.get(source, new String[0]), Paths.get(dest, new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        printWriter.flush();
        LinkedList<String> stack = new LinkedList<String>(Arrays.asList(writer.toString().split("\n\t")));
        return stack;
    }

    public static void disableCertificateValidation() throws Exception {
        TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCertificates, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
    }

    public Double last(List<Double> list) {
        return list.get(list.size() - 1);
    }

    public static String sortAndMerge(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return a.compareTo(b) < 0 ? a + b : b + a;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public boolean isValidChars(String text, String charsStr) {
        for (int i = 0; i < text.length(); ++i) {
            if (charsStr.indexOf(text.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

