/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.utils;

import net.vavilon.token.model.Account;
import net.vavilon.utils.Request;
import net.vavilon.utils.SHA256;
import net.vavilon.utils.Success;
import net.vavilon.utils.Utils;

public class Wallet {
    public static String calcHash(String domain, String username, String password, String prevKey) {
        return SHA256.hash(domain + username + password + (prevKey != null ? prevKey : ""));
    }

    public static void calcStartHash(String address, String password, String domain, Success success) {
        success.run(SHA256.hash(Wallet.calcHash(domain, address, password, "")));
    }

    public static void calcKeyHash(String address, String password, String domain, String prevKey, Success success) {
        String key = Wallet.calcHash(domain, address, password, prevKey);
        String nextHash = SHA256.hash(Wallet.calcHash(domain, address, password, key));
        success.run(key + ":" + nextHash);
    }

    public static void send(String host, String fromAddress, String password, String domain, String prev_key, String toAddress, String amount, Success success, Success error) {
        Wallet.calcKeyHash(fromAddress, password, domain, prev_key, pass -> Request.post(host + "/mfm-token/send", Request.map("domain", domain, "from", fromAddress, "to", toAddress, "amount", amount, "pass", pass), success, error));
    }

    public static void reg(String host, String domain, String address, String password) {
        Wallet.reg(host, domain, address, password, null, null);
    }

    public static void reg(String host, String domain, String address, String password, Success success, Success error) {
        Wallet.calcStartHash(address, password, domain, pass -> Request.post(host + "/mfm-token/send", Request.map("domain", domain, "from", "owner", "to", address, "amount", "0", "pass", ":" + pass), success, error));
    }

    public static void send(String host, String fromAddress, String password, String domain, String toAddress, String amount, Success success, Success error) {
        Request.post(host + "/mfm-token/account", Request.map("domain", domain, "address", fromAddress), responseStr -> {
            AccountResponse response = Utils.gson.fromJson(responseStr, AccountResponse.class);
            Wallet.send(host, fromAddress, password, domain, response.account.prev_key, toAddress, amount, success, error);
        }, response -> Wallet.reg(host, domain, fromAddress, password, response1 -> Wallet.send(host, fromAddress, password, domain, toAddress, amount, success, error), error));
    }

    class AccountResponse {
        Account account;

        AccountResponse() {
        }
    }
}

