/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.quickstart;

import org.eclipse.jetty.ee10.webapp.Descriptor;
import org.eclipse.jetty.ee10.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraXmlDescriptorProcessor
extends IterativeDescriptorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ExtraXmlDescriptorProcessor.class);
    private final StringBuilder _buffer = new StringBuilder();
    private String _originAttribute;
    private String _origin;

    public ExtraXmlDescriptorProcessor() {
        try {
            this.registerVisitor("env-entry", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("resource-ref", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("resource-env-ref", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("message-destination-ref", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
            this.registerVisitor("data-source", ((Object)((Object)this)).getClass().getMethod("saveSnippet", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void start(WebAppContext context, Descriptor descriptor) {
        LOG.debug("process {}", (Object)descriptor);
        this._origin = StringUtil.isBlank(this._originAttribute) ? null : "  <!-- " + String.valueOf(descriptor) + " -->\n";
    }

    public void end(WebAppContext context, Descriptor descriptor) {
    }

    public void setOriginAttribute(String name) {
        this._originAttribute = name;
    }

    public void saveSnippet(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        LOG.debug("save {}", (Object)node.getTag());
        if (this._origin != null) {
            this._buffer.append(this._origin);
        }
        this._buffer.append("  ").append(node.toString()).append("\n");
    }

    public String getXML() {
        return this._buffer.toString();
    }
}

