/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.security.jaspi.modules;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.jetty.ee10.security.jaspi.JaspiMessageInfo;
import org.eclipse.jetty.ee10.security.jaspi.modules.BaseAuthModule;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticationAuthModule
extends BaseAuthModule {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthenticationAuthModule.class);
    private String _realmName;
    private static final String REALM_KEY = "org.eclipse.jetty.ee10.security.jaspi.modules.RealmName";

    public BasicAuthenticationAuthModule() {
    }

    public BasicAuthenticationAuthModule(CallbackHandler callbackHandler, String realmName) {
        super(callbackHandler);
        this._realmName = realmName;
    }

    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler callbackHandler, Map options) throws AuthException {
        super.initialize(requestPolicy, responsePolicy, callbackHandler, options);
        this._realmName = (String)options.get(REALM_KEY);
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        if (!(messageInfo instanceof JaspiMessageInfo)) {
            throw new IllegalStateException("Not a JaspiMessageInfo");
        }
        JaspiMessageInfo jaspiMessageInfo = (JaspiMessageInfo)messageInfo;
        Request request = jaspiMessageInfo.getBaseRequest();
        Response response = jaspiMessageInfo.getBaseResponse();
        String credentials = request.getHeaders().get(HttpHeader.AUTHORIZATION.asString());
        try {
            if (credentials != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: {}", (Object)credentials);
                }
                if (this.login(clientSubject, credentials, "BASIC", messageInfo)) {
                    return AuthStatus.SUCCESS;
                }
            }
            response.getHeaders().put(HttpHeader.WWW_AUTHENTICATE.asString(), "Basic realm=\"" + this._realmName + "\"");
            Response.writeError(request, response, jaspiMessageInfo.getCallback(), 401);
            return AuthStatus.SEND_CONTINUE;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
    }
}

