/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.session.ObjectStreamSessionDataStore;
import org.eclipse.jetty.session.SessionData;

public abstract class NoSqlSessionDataStore
extends ObjectStreamSessionDataStore {
    @Override
    public SessionData newSessionData(String id, long created, long accessed, long lastAccessed, long maxInactiveMs) {
        return new NoSqlSessionData(id, this._context.getCanonicalContextPath(), this._context.getVhost(), created, accessed, lastAccessed, maxInactiveMs);
    }

    public class NoSqlSessionData
    extends SessionData {
        private Object _version;
        private Set<String> _dirtyAttributes;

        public NoSqlSessionData(String id, String cpath, String vhost, long created, long accessed, long lastAccessed, long maxInactiveMs) {
            super(id, cpath, vhost, created, accessed, lastAccessed, maxInactiveMs);
            this._dirtyAttributes = new HashSet<String>();
            this.setVersion(0L);
        }

        public void setVersion(Object v) {
            this._version = v;
        }

        public Object getVersion() {
            return this._version;
        }

        @Override
        public void setDirty(String name) {
            super.setDirty(name);
            this._dirtyAttributes.add(name);
        }

        public Set<String> takeDirtyAttributes() {
            HashSet<String> copy = new HashSet<String>(this._dirtyAttributes);
            this._dirtyAttributes.clear();
            return copy;
        }

        public Set<String> getAllAttributeNames() {
            return new HashSet<String>(this._attributes.keySet());
        }
    }
}

