/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.rewrite.handler.HeaderRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.URIUtil;

public class ForwardedSchemeHeaderRule
extends HeaderRule {
    private String _scheme = "https";

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = URIUtil.normalizeScheme(scheme);
    }

    @Override
    protected Rule.Handler apply(Rule.Handler input, String value) {
        HttpURI.Mutable newURI = HttpURI.build(input.getHttpURI()).scheme(this.getScheme());
        return new Rule.HttpURIHandler(input, newURI);
    }
}

