/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.annotation.Name;

public class RewriteRegexRule
extends RegexRule {
    private String replacement;

    public RewriteRegexRule() {
    }

    public RewriteRegexRule(@Name(value="regex") String regex, @Name(value="replacement") String replacement) {
        super(regex);
        this.setReplacement(replacement);
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public Rule.Handler apply(Rule.Handler input, Matcher matcher) throws IOException {
        HttpURI httpURI = input.getHttpURI();
        String replacedPath = matcher.replaceAll(this.replacement);
        HttpURI.Mutable newURI = HttpURI.build(httpURI, replacedPath);
        return new Rule.HttpURIHandler(input, newURI);
    }

    @Override
    public String toString() {
        return "%s[rewrite:%s]".formatted(super.toString(), this.replacement);
    }
}

