/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.rewrite.handler.RuleContainer;
import org.eclipse.jetty.server.Request;

public class VirtualHostRuleContainer
extends RuleContainer {
    private final List<String> _virtualHosts = new ArrayList<String>();

    public List<String> getVirtualHosts() {
        return this._virtualHosts;
    }

    public void setVirtualHosts(List<String> virtualHosts) {
        this._virtualHosts.clear();
        if (virtualHosts != null) {
            virtualHosts.forEach(this::addVirtualHost);
        }
    }

    public void addVirtualHost(String virtualHost) {
        this._virtualHosts.add(this.normalizeHostName(virtualHost));
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        if (this._virtualHosts.isEmpty()) {
            return super.matchAndApply(input);
        }
        String serverName = Request.getServerName(input);
        for (String virtualHost : this.getVirtualHosts()) {
            if (virtualHost == null || virtualHost.equalsIgnoreCase(serverName)) {
                return super.matchAndApply(input);
            }
            if (!virtualHost.startsWith("*.") || !virtualHost.regionMatches(true, 2, serverName, serverName.indexOf(".") + 1, virtualHost.length() - 2)) continue;
            return super.matchAndApply(input);
        }
        return null;
    }

    private String normalizeHostName(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

