/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.websocket.api.ExtensionConfig;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.core.client.CoreClientUpgradeRequest;

public class DelegatedJettyClientUpgradeRequest
implements UpgradeRequest {
    private final CoreClientUpgradeRequest delegate;
    private final Map<String, List<String>> headers;

    public DelegatedJettyClientUpgradeRequest(CoreClientUpgradeRequest delegate) {
        this.delegate = delegate;
        this.headers = HttpFields.asMap(delegate.getHeaders());
    }

    @Override
    public List<java.net.HttpCookie> getCookies() {
        return this.delegate.getCookies().stream().map(HttpCookie::asJavaNetHttpCookie).toList();
    }

    @Override
    public String getHeader(String name) {
        return this.delegate.getHeaders().get(name);
    }

    @Override
    public int getHeaderInt(String name) {
        HttpField field = this.delegate.getHeaders().getField(name);
        if (field == null) {
            return -1;
        }
        return field.getIntValue();
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.delegate.getHeaders().getValuesList(name);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHost() {
        return this.delegate.getURI().getHost();
    }

    @Override
    public String getHttpVersion() {
        return this.delegate.getVersion().toString();
    }

    public void configure(EndPoint endpoint) {
    }

    @Override
    public String getMethod() {
        return this.delegate.getMethod();
    }

    @Override
    public String getOrigin() {
        return this.delegate.getHeaders().get(HttpHeader.ORIGIN);
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        if (this.getQueryString() == null) {
            return Collections.emptyMap();
        }
        MultiMap<String> params = new MultiMap<String>();
        UrlEncoded.decodeTo(this.getQueryString(), params, StandardCharsets.UTF_8);
        return params;
    }

    @Override
    public String getProtocolVersion() {
        return this.delegate.getHeaders().get(HttpHeader.SEC_WEBSOCKET_VERSION);
    }

    @Override
    public String getQueryString() {
        return this.delegate.getURI().getRawQuery();
    }

    @Override
    public URI getRequestURI() {
        return this.delegate.getURI();
    }

    @Override
    public List<String> getSubProtocols() {
        return this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
    }

    @Override
    public boolean hasSubProtocol(String test) {
        HttpField field = this.delegate.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
        if (field == null) {
            return false;
        }
        return field.contains(test);
    }

    @Override
    public boolean isSecure() {
        return HttpScheme.isSecure(this.delegate.getURI().getScheme());
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    @Override
    public List<ExtensionConfig> getExtensions() {
        List<String> rawExtensions = this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (rawExtensions == null || rawExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        return rawExtensions.stream().map(ExtensionConfig::parse).collect(Collectors.toList());
    }
}

