/*
 * Decompiled with CFR 0.152.
 */
package org.exchange;

import java.util.Scanner;
import net.vavilon.servers.model.Endpoint;
import net.vavilon.servers.model.Subscription;
import net.vavilon.token.TokenUtils;
import net.vavilon.token.model.Token;
import org.exchange.Telegram;
import org.exchange.exchange.Bot;
import org.exchange.exchange.Cancel;
import org.exchange.exchange.CancelAll;
import org.exchange.exchange.DepositSuccess;
import org.exchange.exchange.OrderBook;
import org.exchange.exchange.Orders;
import org.exchange.exchange.Place;

public class Exchange
extends Telegram {
    public static boolean FAST_TEST = false;

    public static void main(String[] args) throws Exception {
        String masterNode = null;
        if (args.length >= 1) {
            masterNode = args[0];
        }
        Exchange exchange = new Exchange(masterNode);
        exchange.start();
        new Scanner(System.in).hasNext();
    }

    public Exchange(String masterNode) throws Exception {
        super(masterNode);
        TokenUtils.depositListeners.add(new DepositSuccess());
        int i = 1;
        while ((long)i < TokenUtils.tokensByDomain.values.size()) {
            Token token = (Token)TokenUtils.tokensByDomain.values.get(i);
            if (!token.domain.equals("usdt")) {
                Bot.bots.computeIfAbsent(token.domain, domain2 -> new Bot((String)domain2)).refresh();
            }
            ++i;
        }
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-exchange/place": {
                return new Place();
            }
            case "mfm-exchange/cancel": {
                return new Cancel();
            }
            case "mfm-exchange/orderbook": {
                return new OrderBook();
            }
            case "mfm-exchange/user_orders": {
                return new Orders();
            }
            case "mfm-exchange/cancel_all": {
                return new CancelAll();
            }
        }
        return super.getEndpoint(uri);
    }

    @Override
    public void onMessage(Subscription sub) {
        super.onMessage(sub);
        String[] topic = sub.subscribe.split(":");
        if (topic[0].equals("orderbook")) {
            Bot.bots.computeIfAbsent(topic[1], domain2 -> new Bot((String)domain2)).refresh();
        }
    }
}

