/*
 * Decompiled with CFR 0.152.
 */
package org.exchange;

import net.vavilon.servers.model.Endpoint;
import net.vavilon.token.Send;
import net.vavilon.token.TokenUtils;
import org.exchange.Bridge;
import org.exchange.miner.DepositSuccess;
import org.exchange.miner.GetAccount;
import org.exchange.miner.Miner;
import org.exchange.miner.MinerUtils;
import org.exchange.miner.SetTariff;
import org.exchange.miner.ToggleDomain;
import org.exchange.miner.Withdrawal;
import org.exchange.miner.model.MinerAccount;

public class MinerFarm
extends Bridge {
    public static final Miner miner = new Miner();

    public MinerFarm(String masterNode) throws Exception {
        super(masterNode);
        this.load();
        miner.start();
        TokenUtils.depositListeners.add(new DepositSuccess());
    }

    void load() {
        Send.regAccount("usdt", MinerUtils.MINER_ADDRESS, MinerUtils.MINER_PASSWORD);
        Send.regAccount("usdt", MinerUtils.ENERGY_ADDRESS, MinerUtils.ENERGY_PASSWORD);
        int i = 0;
        while ((long)i < MinerUtils.minerAccounts.values.size()) {
            MinerAccount minerAccount = (MinerAccount)MinerUtils.minerAccounts.values.get(i);
            MinerFarm.miner.accountsByAddress.put(minerAccount.userAddress, minerAccount);
            ++i;
        }
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-miner/account": {
                return new GetAccount();
            }
            case "mfm-miner/set_tariff": {
                return new SetTariff();
            }
            case "mfm-miner/toggle_domain": {
                return new ToggleDomain();
            }
            case "mfm-miner/withdrawal": {
                return new Withdrawal();
            }
        }
        return super.getEndpoint(uri);
    }
}

