/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.p2p;

import net.vavilon.token.model.Account;
import org.exchange.p2p.OfferUtils;
import org.exchange.p2p.model.Offer;

public class OfferPlace
extends OfferUtils {
    @Override
    public void run() {
        String domain = this.getRequired("domain");
        String address = this.getRequired("address");
        Long is_sell = this.getLongRequired("is_sell");
        Double price = this.getDoubleRequired("price");
        Double amount = this.getDoubleRequired("amount");
        Double min = this.getDoubleRequired("min");
        Double max = this.getDoubleRequired("max");
        String pass = this.getRequired("pass");
        Double total = OfferPlace.round(amount * price);
        if (min >= max) {
            OfferPlace.error("min > max");
        }
        if (price <= 0.0) {
            OfferPlace.error("price <= 0");
        }
        if (min < 0.0) {
            OfferPlace.error("min < 0");
        }
        if (max <= 0.0) {
            OfferPlace.error("max <= 0");
        }
        if (is_sell != 0L && is_sell != 1L) {
            OfferPlace.error("is_sell != 0 && is_sell != 1");
        }
        this.changePass(this.scriptPath, "usdt", address, pass);
        Account account = OfferPlace.getAccount("usdt", address);
        if (is_sell == 1L && account.balance < total) {
            OfferPlace.error("Not enough balance");
        }
        Offer order = new Offer();
        order.id = offers.nextId();
        order.domain = domain;
        order.is_sell = is_sell;
        order.address = address;
        order.price = price;
        order.amount = amount;
        order.min = min;
        order.max = max;
        order.status = "active";
        order.created = this.time();
        offers.add(order);
        offersHistory.addLast(domain, "" + order.id);
        userOffers.addLast(address, "" + order.id);
    }
}

