/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.p2p;

import net.vavilon.servers.WssServer;
import net.vavilon.utils.Request;
import org.exchange.p2p.OfferUtils;
import org.exchange.p2p.model.Offer;
import org.exchange.p2p.model.Order;

public class OrderPlace
extends OfferUtils {
    @Override
    public void run() {
        Long offer_id = this.getLongRequired("offer_id");
        String address = this.getRequired("address");
        String pass = this.getRequired("pass");
        String payment = this.getRequired("payment");
        Double amount = this.getDoubleRequired("amount");
        Offer offer = (Offer)offers.get(offer_id);
        if (offer == null) {
            OrderPlace.error("Order not found");
        }
        if (!offer.status.equals("active")) {
            OrderPlace.error("Order not active");
        }
        if (amount < offer.min) {
            OrderPlace.error("Amount < min");
        }
        if (amount > offer.max) {
            OrderPlace.error("Amount > max");
        }
        if (offer.address.equals(address)) {
            OrderPlace.error("Its your offer");
        }
        this.changePass(this.scriptPath, "usdt", address, pass);
        offer.blocked += amount.doubleValue();
        offers.set(offer_id, offer);
        Order order = new Order();
        order.id = orders.nextId();
        order.offer_id = offer_id;
        order.address = address;
        order.payment = payment;
        order.amount = amount;
        order.status = "active";
        order.created = this.time();
        orders.add(order);
        userOrders.addLast(address, "" + order.id);
        userOrders.addLast(offer.address, "" + order.id);
        WssServer.broadcast("new_order:" + offer.address, Request.map("order_id", "" + order.id));
        this.response.put("order_id", order.id);
    }
}

