/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.p2p;

import org.exchange.p2p.OfferUtils;
import org.exchange.p2p.model.Offer;
import org.exchange.p2p.model.Order;
import org.exchange.p2p.model.User;

public class OrderReceived
extends OfferUtils {
    @Override
    public void run() {
        Offer offer;
        Long order_fill_id = this.getLongRequired("order_id");
        String pass = this.getRequired("pass");
        Order order = (Order)orders.get(order_fill_id);
        if (order == null) {
            OrderReceived.error("Order not found");
        }
        if ((offer = (Offer)offers.get(order.offer_id)) == null) {
            OrderReceived.error("Order not found");
        }
        if (!order.status.equals("sent")) {
            OrderReceived.error("Order not sent");
        }
        order.status = "filled";
        offer.blocked -= order.amount;
        offer.filled += order.amount;
        if (offer.is_sell == 1L) {
            this.tokenSend(this.scriptPath, "usdt", offer.address, order.address, OrderReceived.round(order.amount * offer.price), pass, null);
        } else if (offer.is_sell == 0L) {
            this.tokenSend(this.scriptPath, "usdt", order.address, offer.address, OrderReceived.round(order.amount * offer.price), pass, null);
        }
        User user = (User)users.get(order.address);
        ++user.finishedOrders;
        ++user.successOrders;
        if (offer.is_sell == 0L) {
            ++user.sellOrders;
        }
        if (user.firstOrder == 0L) {
            user.firstOrder = this.time();
        }
        users.put(order.address, user);
        if (offer.filled == offer.amount) {
            offer.status = "filled";
            User merchant = (User)users.get(offer.address);
            ++merchant.finishedOrders;
            ++merchant.successOrders;
            if (offer.is_sell == 1L) {
                ++merchant.sellOrders;
            }
            if (merchant.firstOrder == 0L) {
                merchant.firstOrder = this.time();
            }
            users.put(merchant.address, merchant);
        }
        orders.set(order_fill_id, order);
        offers.set(order.offer_id, offer);
    }
}

