/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.p2p;

import net.vavilon.servers.model.Endpoint;
import org.exchange.Exchange;
import org.exchange.p2p.Chat;
import org.exchange.p2p.ChatSend;
import org.exchange.p2p.OfferCancel;
import org.exchange.p2p.OfferGet;
import org.exchange.p2p.OfferPlace;
import org.exchange.p2p.Offers;
import org.exchange.p2p.OrderAppeal;
import org.exchange.p2p.OrderCancel;
import org.exchange.p2p.OrderGet;
import org.exchange.p2p.OrderPlace;
import org.exchange.p2p.OrderReceived;
import org.exchange.p2p.OrderSent;
import org.exchange.p2p.Orders;
import org.exchange.p2p.PaymentAdd;
import org.exchange.p2p.Profile;

public class P2P
extends Exchange {
    public static void main(String[] args) throws Exception {
        String masterNode = null;
        if (args.length >= 1) {
            masterNode = args[0];
        }
        new P2P(masterNode).start();
    }

    public P2P(String masterNode) throws Exception {
        super(masterNode);
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-direct/offer": {
                return new OfferGet();
            }
            case "mfm-direct/offers": {
                return new Offers();
            }
            case "mfm-direct/offer_place": {
                return new OfferPlace();
            }
            case "mfm-direct/offer_cancel": {
                return new OfferCancel();
            }
            case "mfm-direct/profile": {
                return new Profile();
            }
            case "mfm-direct/payment_add": {
                return new PaymentAdd();
            }
            case "mfm-direct/orders": {
                return new Orders();
            }
            case "mfm-direct/order": {
                return new OrderGet();
            }
            case "mfm-direct/chat_send": {
                return new ChatSend();
            }
            case "mfm-direct/chat": {
                return new Chat();
            }
            case "mfm-direct/order_appeal": {
                return new OrderAppeal();
            }
            case "mfm-direct/order_place": {
                return new OrderPlace();
            }
            case "mfm-direct/order_finish": {
                return new OrderReceived();
            }
            case "mfm-direct/order_sent": {
                return new OrderSent();
            }
            case "mfm-direct/order_cancel": {
                return new OrderCancel();
            }
        }
        return super.getEndpoint(uri);
    }
}

