/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.tests;

import java.math.BigInteger;
import net.vavilon.token.TokenUtils;
import net.vavilon.token.model.Account;
import net.vavilon.token.model.Transaction;
import net.vavilon.utils.Request;
import net.vavilon.utils.Utils;

public class SimpleMiner {
    String masterNode;
    String seed;
    String[] domains;

    public static void main(String[] args) {
        if (args.length > 0) {
            new SimpleMiner("vavilon.org", args, "nation finger unable fade exist visa arch awake anchor surround paddle riot").start();
        }
    }

    public SimpleMiner(String masterNode, String[] domains, String seed) {
        this.masterNode = masterNode;
        this.domains = domains;
        this.seed = seed;
    }

    public Long calcNonce(String domain, String lastHash, Long difficulty) {
        if (lastHash == null) {
            lastHash = "";
        }
        if (difficulty == null) {
            difficulty = 1L;
        }
        for (int i = 0; i < 10000000; ++i) {
            long nonce = (long)(Math.random() * 1.0E8);
            String str = lastHash + domain + nonce;
            String newHash = Utils.hash(str);
            BigInteger hashNumber = new BigInteger(newHash, 16);
            if (!(hashNumber = hashNumber.mod(BigInteger.valueOf(difficulty))).equals(BigInteger.ZERO) && !Thread.currentThread().isInterrupted()) continue;
            return nonce;
        }
        return null;
    }

    public void calcBlock(String domain, String seed) {
        String password = Utils.hash(seed);
        String address = Utils.hashAddress(password);
        Request.post(this.masterNode + "/mfm-contract/mining_info", Request.map("domain", domain, "address", address), infoStr -> {
            MiningInfoResponse info = Utils.gson.fromJson(infoStr, MiningInfoResponse.class);
            Long nonce = this.calcNonce(domain, info.last_hash, info.difficulty);
            if (nonce != null) {
                String pass = TokenUtils.tokenPass("usdt", address, password, info.gas_account.prev_key);
                Request.post(this.masterNode + "/" + info.bank.delegate, Request.map("domain", domain, "nonce", "" + nonce, "time", "" + Utils.timeSec(), "gas_address", address, "gas_pass", pass), mintStr -> System.out.println("success: " + mintStr), mintStr -> System.out.println("error: " + mintStr));
            }
        });
    }

    public void start() {
        if (this.masterNode == null) {
            return;
        }
        while (!Thread.currentThread().isInterrupted()) {
            for (String domain : this.domains) {
                this.calcBlock(domain, this.seed);
            }
        }
    }

    public class MiningInfoResponse {
        public String last_hash;
        public Long difficulty;
        public Transaction last_reward;
        public Account bank;
        public Account gas_account;
    }
}

