/*
 * Decompiled with CFR 0.152.
 */
package org.exchange.tron;

import com.metabrain.gdb.BigMap;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.vavilon.analytics.AnalyticsUtils;
import net.vavilon.utils.InfiniteTimer;
import net.vavilon.utils.Request;
import org.exchange.tron.TronDepositCheck;
import org.exchange.tron.model.TronAddress;

public class TronDepositAddress
extends AnalyticsUtils {
    public static final String[] tron_addresses = new String[]{"TWi1aZGCT9btazsGmBgK2FVnCFgW1Vn8Pr"};
    public static final Map<String, InfiniteTimer> tronCheckers = new HashMap<String, InfiniteTimer>();
    public static final BigMap<TronAddress> tronAddresses = new BigMap<TronAddress>("tronAddresses", TronAddress.class);

    @Override
    public void run() {
        TronAddress tronAddress2;
        String userAddress = this.getRequired("address");
        String depositAddress = null;
        for (String tronAddressStr : tron_addresses) {
            tronAddress2 = tronAddresses.get(tronAddressStr);
            if (tronAddress2 == null || !tronAddress2.userAddress.equals(userAddress)) continue;
            depositAddress = tronAddressStr;
            break;
        }
        if (depositAddress == null) {
            for (String tronAddressStr : tron_addresses) {
                tronAddress2 = tronAddresses.get(tronAddressStr);
                if (tronAddress2 != null && tronAddress2.deadline <= new Date().getTime() / 1000L) continue;
                depositAddress = tronAddressStr;
                break;
            }
        }
        if (depositAddress == null) {
            TronDepositAddress.error("all addresses are busy please try again later");
        }
        int DEADLINE_MINUTES = 10;
        long deadlineTimeSec = this.time() + Duration.ofMinutes(DEADLINE_MINUTES).getSeconds();
        tronAddresses.put(depositAddress, new TronAddress(depositAddress, userAddress, deadlineTimeSec));
        tronCheckers.computeIfAbsent(depositAddress, tronAddress -> new InfiniteTimer(() -> new TronDepositCheck().run("", Request.map("tron_address", tronAddress)), Duration.ofSeconds(5L).toMillis(), Duration.ofMinutes(DEADLINE_MINUTES).toMillis())).restart();
        this.response.put("deposit_address", depositAddress);
        this.response.put("deposit_deadline", deadlineTimeSec);
    }
}

