/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb;

import com.metabrain.gdb.BigFile;
import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;
import java.io.File;

public class BigArray<Type extends BigArrayCell>
extends BigFile {
    private final Class<Type> valClass;
    private final long cellSize;

    public BigArray(String infinityFileID, Class<Type> valClass) {
        this(null, infinityFileID, valClass, Long.MAX_VALUE);
    }

    public BigArray(File parent, String infinityFileID, Class<Type> valClass) {
        this(parent, infinityFileID, valClass, Long.MAX_VALUE);
    }

    public BigArray(File parent, String infinityFileID, Class<Type> valClass, Long maxBlocks) {
        super(parent, infinityFileID);
        this.valClass = valClass;
        this.cellSize = this.createValInstance().build().length;
        this.maxBlocks = maxBlocks;
    }

    public Type createValInstance() {
        try {
            return (Type)((BigArrayCell)this.valClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type get(long index) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            Type result = this.createValInstance();
            byte[] data = result.build();
            byte[] readiedData = this.read(index * (long)data.length, data.length);
            if (readiedData != null) {
                result.parse(new Bytes(readiedData));
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long index, Type obj) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            byte[] data = obj.build();
            this.write(index * (long)data.length, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(Type obj) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            byte[] data = obj.build();
            long lastMaxPosition = super.add(data);
            return lastMaxPosition / (long)data.length - 1L;
        }
    }

    public long size() {
        return this.fileSize / this.cellSize;
    }

    public long nextId() {
        return this.size();
    }
}

