/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb;

import com.metabrain.gdb.BigArray;
import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.model.Crc16;
import com.metabrain.gdb.model.Hash;
import com.metabrain.gdb.model.KeyVal;
import java.io.File;

public class BigMap<Val extends BigArrayCell> {
    public final BigArray<KeyVal> keys;
    private final BigArray<Hash> hashes;
    public final BigArray<Val> values;

    public BigMap(String infinityFileID, Class<Val> valClass) {
        this(null, infinityFileID, valClass);
    }

    public BigMap(File dir, String infinityFileID, Class<Val> valClass) {
        this.keys = new BigArray<KeyVal>(dir, infinityFileID + ".keys", KeyVal.class);
        this.hashes = new BigArray<Hash>(dir, infinityFileID + ".hashes", Hash.class);
        this.values = new BigArray<Val>(dir, infinityFileID + ".values", valClass);
        if (this.hashes.fileSize == 0L) {
            this.hashes.add(new Hash());
            this.keys.add(new KeyVal());
            this.values.add(this.values.createValInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Val get(String key) {
        BigMap bigMap = this;
        synchronized (bigMap) {
            try {
                String hexHash = String.format("%04x", Crc16.hash(key));
                long index = 0L;
                for (int i = 0; i < 4; ++i) {
                    Hash currentHash = this.hashes.get(index);
                    if (currentHash == null) {
                        return null;
                    }
                    index = currentHash.links[Integer.parseInt("" + hexHash.charAt(i), 16)];
                    if (index == 0L) break;
                }
                while (index != 0L) {
                    KeyVal keyVal = this.keys.get(index);
                    if (key.equals(keyVal.key)) {
                        return this.values.get(keyVal.value_index);
                    }
                    index = keyVal.next_key_index;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Val value) {
        BigMap bigMap = this;
        synchronized (bigMap) {
            String hexHash = String.format("%04x", Crc16.hash(key));
            long hashIndex = 0L;
            int link_index = 0;
            for (int i = 0; i < 3; ++i) {
                Hash currentHash = this.hashes.get(hashIndex);
                link_index = Integer.parseInt("" + hexHash.charAt(i), 16);
                if (currentHash.links[link_index] == 0L) {
                    currentHash.links[link_index] = this.hashes.add(new Hash());
                    this.hashes.set(hashIndex, currentHash);
                }
                hashIndex = currentHash.links[link_index];
            }
            Hash lastHash = this.hashes.get(hashIndex);
            link_index = Integer.parseInt("" + hexHash.charAt(3), 16);
            if (lastHash.links[link_index] != 0L) {
                long keyIndex = lastHash.links[link_index];
                while (true) {
                    KeyVal keyVal = this.keys.get(keyIndex);
                    if (key.equals(keyVal.key)) {
                        this.values.set(keyVal.value_index, value);
                        return;
                    }
                    if (keyVal.next_key_index == 0L) {
                        keyVal.next_key_index = this.keys.add(new KeyVal(key, this.values.add(value)));
                        this.keys.set(keyIndex, keyVal);
                        return;
                    }
                    keyIndex = keyVal.next_key_index;
                }
            }
            lastHash.links[link_index] = this.keys.add(new KeyVal(key, this.values.add(value)));
            this.hashes.set(hashIndex, lastHash);
        }
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public long size() {
        return this.values.size();
    }
}

