/*
 * Decompiled with CFR 0.152.
 */
package com.metabrain.gdb.model;

import com.metabrain.gdb.model.BigArrayCell;
import com.metabrain.gdb.utils.Bytes;

public class String1024
implements BigArrayCell {
    private String value;

    public String1024() {
    }

    public String1024(String value) {
        if (value.length() > 1024) {
            throw new RuntimeException("String1024 value length must be less than 1024");
        }
        this.value = value;
    }

    @Override
    public byte[] build() {
        Bytes data = new Bytes();
        data.addBytes(Bytes.fromString(this.value, 1024));
        return data.getBytes();
    }

    @Override
    public void parse(Bytes data) {
        this.value = Bytes.toString(data.read(1024));
    }

    public String toString() {
        return this.value;
    }
}

