/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.analytics;

import com.metabrain.gdb.BigArray;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.vavilon.analytics.model.Candle;
import net.vavilon.analytics.model.Event;
import net.vavilon.servers.model.Endpoint;
import org.exchange.Exchange;

public abstract class AnalyticsUtils
extends Endpoint {
    static final BigArray<Event> events = new BigArray<Event>(new File("events"), "events", Event.class, Long.MAX_VALUE);
    static final Map<String, BigArray<Candle>> charts = new ConcurrentHashMap<String, BigArray<Candle>>();
    public List<Event> newEvents = new ArrayList<Event>();
    public Map<String, Double> newCandles = new ConcurrentHashMap<String, Double>();
    static final Map<String, Long> periodsSec = new HashMap<String, Long>();

    public AnalyticsUtils() {
        periodsSec.put("M", Exchange.FAST_TEST ? 1L : 60L);
        periodsSec.put("D", 86400L);
    }

    public void trackLinear(String key, double value) {
        this.newCandles.put(key, value);
    }

    public void trackAccumulate(String key) {
        this.trackAccumulate(key, 1.0);
    }

    public void trackAccumulate(String key, double value) {
        this.trackLinear(key, AnalyticsUtils.getCandleLastValue(key) + value);
    }

    void commitCharts() {
        for (String key : this.newCandles.keySet()) {
            Double value = this.newCandles.get(key);
            long timestamp = this.time();
            for (String periodName : periodsSec.keySet()) {
                long periodSec = periodsSec.get(periodName);
                long periodTime = timestamp / periodSec * periodSec;
                String chartKey = key + periodName;
                BigArray<Candle> chart = charts.get(chartKey);
                Candle lastCandle = null;
                if (chart != null) {
                    lastCandle = chart.get(chart.size() - 1L);
                }
                if (lastCandle == null || periodTime != lastCandle.time) {
                    Candle candle = new Candle();
                    candle.period = periodName;
                    candle.time = periodTime;
                    candle.low = value;
                    candle.high = value;
                    candle.open = AnalyticsUtils.getCandleLastValue(key);
                    candle.close = value;
                    charts.computeIfAbsent(chartKey, k -> new BigArray<Candle>(new File("charts"), chartKey, Candle.class, periodName.equals("M") ? 2L : Long.MAX_VALUE)).add(candle);
                    continue;
                }
                lastCandle.low = Math.min(lastCandle.low, value);
                lastCandle.high = Math.max(lastCandle.high, value);
                lastCandle.close = value;
                chart.set(chart.size() - 1L, lastCandle);
            }
        }
    }

    public List<Candle> getCandles(String key, String periodName, int count) {
        long periodTime;
        BigArray<Candle> chart = charts.get(key + periodName);
        long periodSec = periodsSec.get(periodName);
        ArrayList<Candle> result = new ArrayList<Candle>();
        if (chart == null || chart.size() == 0L) {
            return result;
        }
        Candle firstCandle = null;
        Candle lastCandle = null;
        HashMap<Long, Candle> candlesMap = new HashMap<Long, Candle>();
        for (long i = Math.max(chart.size() - (long)count, 0L); i < chart.size(); ++i) {
            Candle candle = chart.get(i);
            if (firstCandle == null) {
                firstCandle = candle;
            }
            lastCandle = candle;
            candlesMap.put(candle.time, candle);
        }
        double lastClose = lastCandle.close;
        for (long i = periodTime = this.time() / periodSec * periodSec; i >= firstCandle.time && result.size() < count; i -= periodSec) {
            Candle item = (Candle)candlesMap.get(i);
            if (item == null) {
                Candle newCandle = new Candle();
                newCandle.time = (int)i;
                newCandle.low = lastClose;
                newCandle.high = lastClose;
                newCandle.open = lastClose;
                newCandle.close = lastClose;
                result.add(newCandle);
                continue;
            }
            lastClose = item.open;
            result.add(item);
        }
        Collections.reverse(result);
        return result;
    }

    public List<Candle> getAccumulate(String key, String periodName, int count) {
        List<Candle> candles = this.getCandles(key, periodName, count);
        for (Candle candle : candles) {
            candle.open = AnalyticsUtils.round(candle.open);
            candle.close = AnalyticsUtils.round(candle.close);
            candle.high = AnalyticsUtils.round(candle.high);
            candle.low = AnalyticsUtils.round(candle.low);
            candle.value = AnalyticsUtils.round(candle.close - candle.open);
        }
        return candles;
    }

    public static double getCandleLastValue(String key) {
        return AnalyticsUtils.getCandleLastValue(key, "M");
    }

    public static double getCandleLastValue(String key, String periodName) {
        BigArray<Candle> chart = charts.get(key + periodName);
        if (chart == null) {
            return 0.0;
        }
        return chart.get((long)(chart.size() - 1L)).close;
    }

    public double getCandleChange24h(String key) {
        return this.getCandleChangeDays(key, 1);
    }

    public double getCandleChange7d(String key) {
        return this.getCandleChangeDays(key, 7);
    }

    public double getCandleChangeDays(String key, int count) {
        List<Candle> chart = this.getCandles(key, "D", count + 1);
        if (chart == null || chart.size() == 0) {
            return 0.0;
        }
        if (chart.size() == 1) {
            Candle candle = chart.get(0);
            candle.open = candle.close;
            return candle.open;
        }
        return chart.get((int)(chart.size() - 1)).close - chart.get((int)0).close;
    }

    public void trackEvent(String name, String value, String userId, String session) {
        Event event = new Event();
        event.time = this.time();
        event.name = name;
        event.value = value;
        event.user_id = userId;
        event.session = session;
        this.newEvents.add(event);
    }

    public void commitEvents() {
        for (Event event : this.newEvents) {
            events.add(event);
        }
        this.newEvents.clear();
    }

    public Event getEvent(String name, String value, String session) {
        List<Event> events = this.getEvents(name, value, session, null, 1L);
        return events.isEmpty() ? null : events.get(0);
    }

    public List<Event> getEvents(String name, String value, String session, Long fromTime, Long size) {
        Event event;
        long i = events.size() - 1L;
        ArrayList<Event> result = new ArrayList<Event>();
        while (i >= 0L && (long)result.size() < size && (fromTime == null || fromTime > 0L) && (event = events.get(i)) != null) {
            if (name != null && !name.equals(event.name)) {
                --i;
                continue;
            }
            if (value != null && !value.equals(event.value)) {
                --i;
                continue;
            }
            if (session != null && !session.equals(event.session)) {
                --i;
                continue;
            }
            if (fromTime != null && event.time < fromTime) break;
            result.add(event);
            --i;
        }
        return result;
    }

    @Override
    public void commit() {
        this.commitEvents();
        this.commitCharts();
    }
}

