/*
 * Decompiled with CFR 0.152.
 */
package net.vavilon.analytics;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.vavilon.analytics.AnalyticsUtils;
import net.vavilon.analytics.model.Event;

public class Funnel
extends AnalyticsUtils {
    private List<Step> parseFunnel(String funnel) {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (String nameValueStr : funnel.split(",")) {
            Step step = new Step();
            step.str = nameValueStr;
            String[] nameValue = nameValueStr.split("=");
            step.name = nameValue[0];
            step.value = nameValue.length > 1 ? nameValue[1] : null;
            steps.add(step);
        }
        return steps;
    }

    @Override
    public void run() {
        String funnel = this.getRequired("funnel");
        long timeFrom = this.time() - 604800L;
        List<Step> parsedFunnel = this.parseFunnel(funnel);
        Step firstStep = parsedFunnel.remove(0);
        List<Event> events = this.getEvents(firstStep.name, firstStep.value, null, timeFrom, 10000L);
        firstStep.count = events.size();
        if (!events.isEmpty()) {
            for (Event event : events) {
                for (Step step : parsedFunnel) {
                    Event nextStep = this.getEvent(step.name, step.value, event.session);
                    if (nextStep == null) continue;
                    ++step.count;
                }
            }
        }
        if (firstStep.count == 0) {
            this.response.put("sessions", 0);
            this.response.put("success_percent", 0);
        } else {
            this.response.put("sessions", firstStep.count);
            this.response.put("success_percent", (double)Math.round((double)parsedFunnel.get((int)(parsedFunnel.size() - 1)).count / (double)firstStep.count * 10000.0) / 100.0);
        }
        parsedFunnel.add(0, firstStep);
        LinkedHashMap<String, Integer> funnelMap = new LinkedHashMap<String, Integer>();
        for (Step step : parsedFunnel) {
            funnelMap.put(step.str, step.count);
        }
        this.response.put("funnel", funnelMap);
    }

    class Step {
        String str;
        String name;
        String value;
        int count = 0;

        Step() {
        }
    }
}

